/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.config.cloth;

import dev.the_fireplace.lib.domain.config.OptionTypeConverter;

public final class FloatingPointClothConverter<T extends Number>
implements OptionTypeConverter<T, Long> {
    public static final byte INITIAL_PRECISION = 1;
    private byte precision = 1;

    @Override
    public Long convertToClothType(T source) {
        double factor = Math.pow(10.0, this.precision);
        return (long)(((Number)source).doubleValue() * factor);
    }

    @Override
    public T convertFromClothType(Long clothValue) {
        double factor = Math.pow(10.0, this.precision);
        return (T)Double.valueOf((double)clothValue.longValue() / factor);
    }

    public void setPrecision(byte precision) {
        this.precision = precision;
    }
}

