/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.config.cloth.custombutton;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.the_fireplace.lib.FireplaceLibConstants;
import dev.the_fireplace.lib.api.client.interfaces.CustomButtonScreen;
import dev.the_fireplace.lib.api.client.interfaces.CustomButtonScreenFactory;
import dev.the_fireplace.lib.api.multithreading.injectables.ExecutionManager;
import dev.the_fireplace.lib.config.cloth.ClothConfigDependencyHandler;
import io.netty.util.concurrent.Promise;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class CustomButtonEntry
extends TooltipListEntry<String> {
    private final AtomicReference<String> value;
    private final String original;
    private final Button buttonWidget;
    private final Button resetButton;
    private final Consumer<String> saveConsumer;
    private final Supplier<String> defaultValue;
    private final List<AbstractWidget> widgets;
    private final Function<String, Component> getDisplayText;

    public CustomButtonEntry(Component fieldName, String currentValue, Component resetButtonKey, Supplier<String> defaultValue, Consumer<String> saveConsumer, CustomButtonScreenFactory<String, ?> buildOptionScreenFactory, Function<String, Component> getDisplayText) {
        super(fieldName, null);
        this.defaultValue = defaultValue;
        this.original = currentValue;
        this.value = new AtomicReference<String>(currentValue);
        this.buttonWidget = new Button(0, 0, 150, 20, (Component)Component.m_237119_(), widget -> {
            Object optionBuilderScreen = buildOptionScreenFactory.createScreen(Minecraft.m_91087_().f_91080_, this.value.get());
            Promise willReturnNewValuePromise = ((CustomButtonScreen)optionBuilderScreen).getNewValuePromise();
            Minecraft.m_91087_().m_91152_(optionBuilderScreen);
            ((ExecutionManager)FireplaceLibConstants.getInjector().getInstance(ExecutionManager.class)).runKillable(() -> {
                Optional builderReturnedValue = Optional.empty();
                try {
                    builderReturnedValue = (Optional)willReturnNewValuePromise.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
                builderReturnedValue.ifPresent(this.value::set);
            });
        });
        this.resetButton = new Button(0, 0, Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)resetButtonKey) + 6, 20, resetButtonKey, widget -> this.value.set((String)defaultValue.get()));
        this.saveConsumer = saveConsumer;
        this.widgets = Lists.newArrayList((Object[])new AbstractWidget[]{this.buttonWidget, this.resetButton});
        this.getDisplayText = getDisplayText;
    }

    public boolean isEdited() {
        return super.isEdited() || !Objects.equals(this.original, this.value.get());
    }

    public void save() {
        if (this.saveConsumer != null) {
            this.saveConsumer.accept(this.getValue());
        }
    }

    public String getValue() {
        return this.value.get();
    }

    public Optional<String> getDefaultValue() {
        return this.defaultValue == null ? Optional.empty() : Optional.ofNullable(this.defaultValue.get());
    }

    public void render(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        if (ClothConfigDependencyHandler.DISABLED_ENTRIES.contains((Object)this)) {
            return;
        }
        super.render(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        Window window = Minecraft.m_91087_().m_91268_();
        this.resetButton.f_93623_ = this.isEditable() && this.getDefaultValue().isPresent() && !Objects.equals(this.defaultValue.get(), this.value.get());
        this.resetButton.f_93621_ = y;
        this.buttonWidget.f_93623_ = this.isEditable();
        this.buttonWidget.f_93621_ = y;
        Component buttonText = this.getDisplayText != null ? this.getDisplayText.apply(this.value.get()) : Component.m_130674_((String)this.value.get());
        this.buttonWidget.m_93666_(buttonText);
        Component displayedFieldName = this.getDisplayedFieldName();
        if (Minecraft.m_91087_().f_91062_.m_92718_()) {
            Minecraft.m_91087_().f_91062_.m_92744_(matrices, displayedFieldName.m_7532_(), (float)(window.m_85445_() - x - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)displayedFieldName)), (float)(y + 6), 0xFFFFFF);
            this.resetButton.f_93620_ = x;
            this.buttonWidget.f_93620_ = x + this.resetButton.m_5711_() + 2;
        } else {
            Minecraft.m_91087_().f_91062_.m_92744_(matrices, displayedFieldName.m_7532_(), (float)x, (float)(y + 6), this.getPreferredTextColor());
            this.resetButton.f_93620_ = x + entryWidth - this.resetButton.m_5711_();
            this.buttonWidget.f_93620_ = x + entryWidth - 150;
        }
        this.buttonWidget.m_93674_(150 - this.resetButton.m_5711_() - 2);
        this.resetButton.m_6305_(matrices, mouseX, mouseY, delta);
        this.buttonWidget.m_6305_(matrices, mouseX, mouseY, delta);
    }

    public List<? extends NarratableEntry> narratables() {
        return this.widgets;
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.widgets;
    }
}

