/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.config.cloth.optionbuilder;

import dev.the_fireplace.lib.FireplaceLibConstants;
import dev.the_fireplace.lib.api.chat.interfaces.Translator;
import dev.the_fireplace.lib.api.client.interfaces.DecimalSliderOptionBuilder;
import dev.the_fireplace.lib.config.cloth.FloatingPointClothConverter;
import dev.the_fireplace.lib.config.cloth.optionbuilder.ClothNumericOption;
import dev.the_fireplace.lib.domain.config.OptionTypeConverter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import java.util.function.Function;
import me.shedaniel.clothconfig2.impl.builders.FieldBuilder;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.ArrayUtils;

public class ClothDecimalSliderOption<S, T>
extends ClothNumericOption<S, T>
implements DecimalSliderOptionBuilder<S> {
    private final S originalMinimum;
    private final S originalMaximum;
    private final S originalCurrent;
    private final S originalDefault;
    private byte precision = 1;
    private boolean isPercent = false;

    public ClothDecimalSliderOption(Translator translator, FieldBuilder<T, ?, ?> fieldBuilder, String optionTranslationBase, S defaultValue, Consumer<S> saveFunction, S currentValue, S minimum, S maximum, OptionTypeConverter<S, T> typeConverter) {
        super(translator, fieldBuilder, optionTranslationBase, defaultValue, saveFunction, typeConverter);
        this.originalMinimum = minimum;
        this.originalMaximum = maximum;
        this.originalCurrent = currentValue;
        this.originalDefault = defaultValue;
        this.resetDisplayPrecision();
    }

    @Override
    public DecimalSliderOptionBuilder<S> setPrecision(byte precision) {
        this.precision = precision;
        this.resetSliderToPrecision(precision);
        this.resetDisplayPrecision();
        return this;
    }

    @Override
    public DecimalSliderOptionBuilder<S> enablePercentMode() {
        this.isPercent = true;
        return this;
    }

    private void resetSliderToPrecision(byte precision) {
        if (this.typeConverter instanceof FloatingPointClothConverter) {
            ((FloatingPointClothConverter)this.typeConverter).setPrecision(precision);
            this.setMinimum(this.originalMinimum);
            this.setMaximum(this.originalMaximum);
            this.setDefaultValue(this.originalDefault);
            this.setCurrentValue(this.originalCurrent);
        }
    }

    protected void setCurrentValue(S currentValue) {
        Object clothCurrentValue = this.typeConverter.convertToClothType(currentValue);
        try {
            Field currentValueField = this.fieldBuilder.getClass().getField("value");
            currentValueField.set(this.fieldBuilder, clothCurrentValue);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            FireplaceLibConstants.getLogger().error("Unable to set current value for field builder of type " + String.valueOf(this.fieldBuilder.getClass()) + " with current value type " + String.valueOf(clothCurrentValue.getClass()), (Throwable)e);
            FireplaceLibConstants.getLogger().trace(ArrayUtils.toString((Object)this.fieldBuilder.getClass().getFields()));
        }
    }

    protected void resetDisplayPrecision() {
        Function<Object, Component> textGetter = value -> Component.m_130674_((String)(String.format("%." + this.precision + "f", this.typeConverter.convertFromClothType(value)) + (this.isPercent ? "%" : "")));
        try {
            Method setDefaultValue = this.findSingleParameterMethod("setTextGetter", textGetter.getClass());
            setDefaultValue.invoke((Object)this.fieldBuilder, textGetter);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            FireplaceLibConstants.getLogger().error("Unable to set display precision for field builder of type " + String.valueOf(this.fieldBuilder.getClass()), (Throwable)e);
            FireplaceLibConstants.getLogger().trace(ArrayUtils.toString((Object)this.fieldBuilder.getClass().getMethods()));
        }
    }
}

