/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.config.cloth.optionbuilder;

import dev.the_fireplace.lib.FireplaceLibConstants;
import dev.the_fireplace.lib.api.chat.interfaces.Translator;
import dev.the_fireplace.lib.api.client.interfaces.OptionBuilder;
import dev.the_fireplace.lib.config.cloth.ClothParameterTypeConverter;
import dev.the_fireplace.lib.domain.config.OptionTypeConverter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import me.shedaniel.clothconfig2.impl.builders.FieldBuilder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.ArrayUtils;

public class ClothGenericOption<S, T>
implements OptionBuilder<S> {
    private final Translator translator;
    protected final FieldBuilder<T, ?, ?> fieldBuilder;
    private final String optionTranslationBase;
    private final Map<OptionBuilder<?>, Predicate<?>> dependencies = new ConcurrentHashMap();
    protected final OptionTypeConverter<S, T> typeConverter;
    protected final List<Component> tooltipRows = new ArrayList<Component>();

    public ClothGenericOption(Translator translator, FieldBuilder<S, ?, ?> fieldBuilder, String optionTranslationBase, S defaultValue, Consumer<S> saveFunction) {
        this.translator = translator;
        try {
            this.fieldBuilder = fieldBuilder;
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("No type converter provided for Cloth Option!", e);
        }
        this.optionTranslationBase = optionTranslationBase;
        this.typeConverter = new OptionTypeConverter<S, T>(){

            @Override
            public T convertToClothType(S source) {
                return source;
            }

            @Override
            public S convertFromClothType(T clothValue) {
                return clothValue;
            }
        };
        this.setDefaultValue(defaultValue);
        this.setSaveConsumer(saveFunction);
        this.setDescriptionRowCount((byte)1);
        this.tooltipRows.clear();
    }

    public ClothGenericOption(Translator translator, FieldBuilder<T, ?, ?> fieldBuilder, String optionTranslationBase, S defaultValue, Consumer<S> saveFunction, OptionTypeConverter<S, T> typeConverter) {
        this.translator = translator;
        this.fieldBuilder = fieldBuilder;
        this.optionTranslationBase = optionTranslationBase;
        this.typeConverter = typeConverter;
        this.setDefaultValue(defaultValue);
        this.setSaveConsumer(saveFunction);
        this.setDescriptionRowCount((byte)1);
        this.tooltipRows.clear();
    }

    protected void setDefaultValue(S defaultValue) {
        T clothDefaultValue = this.typeConverter.convertToClothType(defaultValue);
        try {
            Method setDefaultValue = this.findSingleParameterMethod("setDefaultValue", clothDefaultValue.getClass());
            setDefaultValue.invoke(this.fieldBuilder, clothDefaultValue);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            FireplaceLibConstants.getLogger().error("Unable to set default value for field builder of type " + String.valueOf(this.fieldBuilder.getClass()) + " with default value type " + String.valueOf(clothDefaultValue.getClass()), (Throwable)e);
            FireplaceLibConstants.getLogger().trace(ArrayUtils.toString((Object)this.fieldBuilder.getClass().getMethods()));
        }
    }

    private void setSaveConsumer(Consumer<S> saveConsumer) {
        Consumer<Object> clothSaveConsumer = value -> saveConsumer.accept(this.typeConverter.convertFromClothType(value));
        try {
            Method setSaveConsumer = this.findSingleParameterMethod("setSaveConsumer", clothSaveConsumer.getClass());
            setSaveConsumer.invoke(this.fieldBuilder, clothSaveConsumer);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            FireplaceLibConstants.getLogger().error("Unable to set save consumer for field builder of type " + String.valueOf(this.fieldBuilder.getClass()), (Throwable)e);
            FireplaceLibConstants.getLogger().trace(ArrayUtils.toString((Object)this.fieldBuilder.getClass().getMethods()));
        }
    }

    @Override
    public OptionBuilder<S> setDescriptionRowCount(byte descriptionRowCount) {
        String descriptionTranslationKey = this.optionTranslationBase + ".desc";
        Component[] descriptionRows = descriptionRowCount == 1 ? new Component[]{this.translator.getTranslatedText(descriptionTranslationKey, new Object[0])} : this.generateMultilineDescription(descriptionTranslationKey, descriptionRowCount);
        this.tooltipRows.addAll(List.of(descriptionRows));
        this.setTooltip();
        return this;
    }

    private void setTooltip() {
        try {
            Method setTooltip = this.fieldBuilder.getClass().getMethod("setTooltip", Component[].class);
            setTooltip.invoke(this.fieldBuilder, new Object[]{this.tooltipRows.toArray(new Component[0])});
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            FireplaceLibConstants.getLogger().error("Unable to set tooltip for field builder of type " + String.valueOf(this.fieldBuilder.getClass()), (Throwable)e);
            FireplaceLibConstants.getLogger().trace(ArrayUtils.toString((Object)this.fieldBuilder.getClass().getMethods()));
        }
    }

    @Override
    public OptionBuilder<S> appendCustomDescriptionRow(Component customRow) {
        this.tooltipRows.add(customRow);
        this.setTooltip();
        return this;
    }

    private Component[] generateMultilineDescription(String baseKey, int count) {
        ArrayList<MutableComponent> texts = new ArrayList<MutableComponent>();
        for (int i = 0; i < count; ++i) {
            texts.add(this.translator.getTranslatedText(baseKey + "[" + i + "]", new Object[0]));
        }
        return texts.toArray(new Component[0]);
    }

    @Override
    public OptionBuilder<S> setErrorSupplier(Function<S, Optional<Component>> errorSupplier) {
        Function<Object, Optional> clothErrorSupplier = value -> (Optional)errorSupplier.apply(this.typeConverter.convertFromClothType(value));
        try {
            Method setErrorSupplier = this.findSingleParameterMethod("setErrorSupplier", clothErrorSupplier.getClass());
            setErrorSupplier.invoke(this.fieldBuilder, clothErrorSupplier);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            FireplaceLibConstants.getLogger().error("Unable to set error supplier for field builder of type " + String.valueOf(this.fieldBuilder.getClass()), (Throwable)e);
            FireplaceLibConstants.getLogger().error(ArrayUtils.toString((Object)this.fieldBuilder.getClass().getMethods()));
        }
        return this;
    }

    protected Method findSingleParameterMethod(String methodName, Class<?> parameterClass) throws NoSuchMethodException {
        Iterator<Class<?>> checkClasses = ClothParameterTypeConverter.getPotentialClasses(parameterClass);
        while (true) {
            try {
                Class<?> testClass = checkClasses.next();
                return this.fieldBuilder.getClass().getMethod(methodName, testClass);
            }
            catch (NoSuchMethodException e) {
                if (checkClasses.hasNext()) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public OptionBuilder<S> addDependency(OptionBuilder<Boolean> parent) {
        return this.addDependency(parent, parentValue -> parentValue);
    }

    @Override
    public <U> OptionBuilder<S> addDependency(OptionBuilder<U> parent, Predicate<U> dependencyMet) {
        this.dependencies.put(parent, dependencyMet);
        return this;
    }

    public final FieldBuilder<T, ?, ?> getFieldBuilder() {
        return this.fieldBuilder;
    }

    public OptionTypeConverter<S, T> getTypeConverter() {
        return this.typeConverter;
    }

    public Map<OptionBuilder<?>, Predicate<?>> getDependencies() {
        return this.dependencies;
    }
}

