/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.init;

import dev.the_fireplace.lib.FireplaceLibConstants;
import dev.the_fireplace.lib.api.chat.injectables.TranslatorFactory;
import dev.the_fireplace.lib.api.lazyio.injectables.SaveTimer;
import dev.the_fireplace.lib.api.lifecycle.injectables.ServerLifecycle;
import dev.the_fireplace.lib.api.multithreading.injectables.ExecutionManager;
import dev.the_fireplace.lib.command.FLCommands;
import dev.the_fireplace.lib.network.NetworkEvents;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.minecraft.server.MinecraftServer;

@Singleton
public final class FireplaceLibInitializer {
    private boolean initialized = false;
    private final TranslatorFactory translatorFactory;
    private final ExecutionManager executionManager;
    private final FLCommands fireplaceLibCommands;
    private final SaveTimer saveTimer;
    private final ServerLifecycle serverLifecycle;
    private final NetworkEvents networkEvents;

    @Inject
    public FireplaceLibInitializer(TranslatorFactory translatorFactory, ExecutionManager executionManager, FLCommands fireplaceLibCommands, SaveTimer saveTimer, ServerLifecycle serverLifecycle, NetworkEvents networkEvents) {
        this.translatorFactory = translatorFactory;
        this.executionManager = executionManager;
        this.fireplaceLibCommands = fireplaceLibCommands;
        this.saveTimer = saveTimer;
        this.serverLifecycle = serverLifecycle;
        this.networkEvents = networkEvents;
    }

    public void init() {
        if (!this.initialized) {
            this.initialized = true;
            this.translatorFactory.addTranslator("fireplacelib");
            this.networkEvents.init();
            this.serverLifecycle.registerServerStartingCallback(this::onServerStarting);
            this.serverLifecycle.registerServerStoppingCallback(this::onServerStopping);
            this.serverLifecycle.registerServerStoppedCallback(s -> FireplaceLibConstants.setMinecraftServer(null));
        }
    }

    private void onServerStarting(MinecraftServer server) {
        FireplaceLibConstants.setMinecraftServer(server);
        this.executionManager.startExecutors();
        this.saveTimer.resetTimer();
        this.fireplaceLibCommands.register(server);
    }

    private void onServerStopping(MinecraftServer server) {
        this.saveTimer.prepareForServerShutdown();
        try {
            this.executionManager.waitForCompletion();
        }
        catch (InterruptedException e) {
            FireplaceLibConstants.getLogger().error("Interrupted while trying to wait for execution manager to complete.", (Throwable)e);
        }
    }
}

