/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.init;

import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.api.lifecycle.injectables.ServerLifecycle;
import java.util.function.Consumer;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Implementation
public final class ForgeSpecificInitialization
implements ServerLifecycle {
    @Override
    public void registerServerStartingCallback(Consumer<MinecraftServer> runnable) {
        MinecraftForge.EVENT_BUS.register((Object)new ServerStarting(runnable));
    }

    @Override
    public void registerServerStoppingCallback(Consumer<MinecraftServer> runnable) {
        MinecraftForge.EVENT_BUS.register((Object)new ServerStopping(runnable));
    }

    @Override
    public void registerServerStoppedCallback(Consumer<MinecraftServer> runnable) {
        MinecraftForge.EVENT_BUS.register((Object)new ServerStopped(runnable));
    }

    private record ServerStarting(Consumer<MinecraftServer> runnable) {
        @SubscribeEvent
        public void onServerStarting(ServerStartingEvent event) {
            this.runnable.accept(event.getServer());
        }
    }

    private record ServerStopping(Consumer<MinecraftServer> runnable) {
        @SubscribeEvent
        public void onServerStopping(ServerStoppingEvent event) {
            this.runnable.accept(event.getServer());
        }
    }

    private record ServerStopped(Consumer<MinecraftServer> runnable) {
        @SubscribeEvent
        public void onServerStopped(ServerStoppedEvent event) {
            this.runnable.accept(event.getServer());
        }
    }
}

