/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.inventory;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.api.inventory.injectables.InventorySearcher;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;

@Implementation
public final class InventorySearcherImpl
implements InventorySearcher {
    @Override
    public boolean hasSlotMatching(Container inventory, Predicate<ItemStack> matcher) {
        for (int slot = 0; slot < inventory.m_6643_(); ++slot) {
            if (!matcher.test(inventory.m_8020_(slot))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Optional<Integer> findFirstMatchingSlot(Container inventory, Predicate<ItemStack> matcher) {
        for (int slot = 0; slot < inventory.m_6643_(); ++slot) {
            if (!matcher.test(inventory.m_8020_(slot))) continue;
            return Optional.of(slot);
        }
        return Optional.empty();
    }

    @Override
    public List<Integer> findMatchingSlots(Container inventory, Predicate<ItemStack> matcher) {
        IntArrayList slotList = new IntArrayList();
        for (int slot = 0; slot < inventory.m_6643_(); ++slot) {
            if (!matcher.test(inventory.m_8020_(slot))) continue;
            slotList.add(slot);
        }
        return slotList;
    }

    @Override
    public Multimap<Integer, Integer> getMatchingSlotsByPriority(Container inventory, Predicate<ItemStack> matcher, ToIntFunction<ItemStack> priorityMapper) {
        IntArrayList slotList = new IntArrayList();
        for (int slot = 0; slot < inventory.m_6643_(); ++slot) {
            if (!matcher.test(inventory.m_8020_(slot))) continue;
            slotList.add(slot);
        }
        Multimap<Integer, Integer> slotPriorityMap = LinkedHashMultimap.create();
        IntListIterator intListIterator = slotList.iterator();
        while (intListIterator.hasNext()) {
            int slot = (Integer)intListIterator.next();
            slotPriorityMap.put((Object)priorityMapper.applyAsInt(inventory.m_8020_(slot)), (Object)slot);
        }
        slotPriorityMap = this.sortByKey(slotPriorityMap);
        return slotPriorityMap;
    }

    @Override
    public Multimap<Integer, Integer> getSlotsByPriority(Container inventory, ToIntFunction<ItemStack> priorityMapper) {
        Multimap<Integer, Integer> slotPriorityMap = LinkedHashMultimap.create();
        for (int slot = 0; slot < inventory.m_6643_(); ++slot) {
            slotPriorityMap.put((Object)priorityMapper.applyAsInt(inventory.m_8020_(slot)), (Object)slot);
        }
        slotPriorityMap = this.sortByKey(slotPriorityMap);
        return slotPriorityMap;
    }

    private Multimap<Integer, Integer> sortByKey(Multimap<Integer, Integer> slotPriorityMap) {
        slotPriorityMap = (Multimap)slotPriorityMap.entries().stream().sorted((i1, i2) -> Integer.compare((Integer)i2.getKey(), (Integer)i1.getKey())).collect(Multimaps.toMultimap(Map.Entry::getKey, Map.Entry::getValue, LinkedHashMultimap::create));
        return slotPriorityMap;
    }
}

