/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.io;

import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.api.io.injectables.JarFileWalker;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Singleton;

@Singleton
@Implementation
public final class JarFileWalkerImpl
implements JarFileWalker {
    private final ConcurrentMap<String, Object> locks = new ConcurrentHashMap<String, Object>();

    @Override
    public Collection<Path> getFiles(String path) throws IOException, URISyntaxException {
        URI uri = JarFileWalkerImpl.class.getResource(path).toURI();
        Stream<Path> paths = "jar".equals(uri.getScheme()) ? this.safeWalkJar(path, uri) : Files.walk(Paths.get(path, new String[0]), new FileVisitOption[0]);
        return paths.collect(Collectors.toSet());
    }

    private Stream<Path> safeWalkJar(String path, URI uri) throws IOException {
        Object object = this.getLock(uri);
        synchronized (object) {
            Stream<Path> stream;
            block9: {
                FileSystem fs = this.getFileSystem(uri);
                try {
                    stream = Files.walk(fs.getPath(path, new String[0]), new FileVisitOption[0]);
                    if (fs == null) break block9;
                }
                catch (Throwable throwable) {
                    if (fs != null) {
                        try {
                            fs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                fs.close();
            }
            return stream;
        }
    }

    private Object getLock(URI uri) {
        String fileName = this.parseFileName(uri);
        this.locks.computeIfAbsent(fileName, s -> new Object());
        return this.locks.get(fileName);
    }

    private String parseFileName(URI uri) {
        String schemeSpecificPart = uri.getSchemeSpecificPart();
        return schemeSpecificPart.substring(0, schemeSpecificPart.indexOf(33));
    }

    private FileSystem getFileSystem(URI uri) throws IOException {
        try {
            return FileSystems.getFileSystem(uri);
        }
        catch (FileSystemNotFoundException e) {
            return FileSystems.newFileSystem(uri, Collections.emptyMap());
        }
    }
}

