/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.io;

import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.api.io.injectables.FilePathStorage;
import dev.the_fireplace.lib.api.io.interfaces.access.StorageReadBuffer;
import dev.the_fireplace.lib.api.io.interfaces.access.StorageWriteBuffer;
import dev.the_fireplace.lib.api.lazyio.injectables.ConfigStateManager;
import dev.the_fireplace.lib.api.lazyio.interfaces.Config;
import dev.the_fireplace.lib.api.lazyio.interfaces.Defaultable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@Implementation(value={"dev.the_fireplace.lib.api.io.injectables.FilePathStorage"})
public final class LazyFilePathStorage
implements Config,
Defaultable,
FilePathStorage {
    private final ConcurrentMap<String, String> lazyMemory;
    private final ConfigStateManager configStateManager;

    @Inject
    public LazyFilePathStorage(ConfigStateManager configStateManager) {
        this.configStateManager = configStateManager;
        this.lazyMemory = new ConcurrentHashMap<String, String>(1);
        configStateManager.initialize(this);
    }

    @Override
    public String getSubfolderName() {
        return "fireplacelib";
    }

    @Override
    public String getId() {
        return "paths";
    }

    @Override
    public void readFrom(StorageReadBuffer buffer) {
        for (String key : buffer.getKeys()) {
            this.lazyMemory.put(key, buffer.readString(key, ""));
        }
    }

    @Override
    public void writeTo(StorageWriteBuffer buffer) {
        for (Map.Entry entry : this.lazyMemory.entrySet()) {
            buffer.writeString((String)entry.getKey(), (String)entry.getValue());
        }
    }

    @Override
    public boolean isDefault() {
        return this.lazyMemory.isEmpty() || this.lazyMemory.values().stream().allMatch(String::isEmpty);
    }

    @Override
    @Nullable
    public String getFilePath(String key) {
        return (String)this.lazyMemory.get(key);
    }

    @Override
    public void storeFilePath(String key, String path) {
        this.lazyMemory.put(key, path);
        this.configStateManager.save(this);
    }
}

