/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.io.access;

import dev.the_fireplace.lib.api.io.injectables.DirectoryResolver;
import dev.the_fireplace.lib.api.io.interfaces.SaveBasedSerializable;
import dev.the_fireplace.lib.io.access.SchemaValidator;
import java.nio.file.Path;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.minecraft.resources.ResourceLocation;

@Singleton
public final class JsonStoragePath {
    private final DirectoryResolver directoryResolver;

    @Inject
    public JsonStoragePath(DirectoryResolver directoryResolver) {
        this.directoryResolver = directoryResolver;
    }

    Path resolveSaveBasedJsonFilePath(SaveBasedSerializable saveBasedSerializable) {
        return this.resolveSaveBasedJsonFilePath(saveBasedSerializable.getDatabase(), saveBasedSerializable.getTable(), saveBasedSerializable.getId());
    }

    Path resolveSaveBasedJsonFilePath(String database, String table, String id) {
        Path filePath = this.resolveSaveBasedJsonDirectory(database, table);
        if (!id.isEmpty() && SchemaValidator.isValid(id)) {
            return filePath.resolve(SchemaValidator.minimizeSchema(id) + ".json");
        }
        throw new IllegalStateException("Invalid storable ID!");
    }

    Path resolveSaveBasedJsonDirectory(String database, String table) {
        Path filePath = this.directoryResolver.getSavePath();
        if (database.isEmpty() || !SchemaValidator.isValid(database)) {
            throw new IllegalStateException("Invalid storable database!");
        }
        filePath = filePath.resolve(SchemaValidator.minimizeSchema(database));
        if (table.isEmpty() || !SchemaValidator.isValid(table)) {
            throw new IllegalStateException("Invalid storable table!");
        }
        filePath = filePath.resolve(SchemaValidator.minimizeSchema(table));
        return filePath;
    }

    public Path resolveConfigBasedJsonFilePath(String domain, String id) {
        Path filePath = this.resolveConfigSubfolderPath(domain);
        if (id.isEmpty() || !SchemaValidator.isValid(id)) {
            throw new IllegalStateException("Invalid storable ID!");
        }
        filePath = filePath.resolve(SchemaValidator.minimizeSchema(id) + ".json");
        return filePath;
    }

    Path resolveConfigSubfolderPath(String subfolder) {
        Path filePath = this.directoryResolver.getConfigPath();
        if (!(subfolder = SchemaValidator.minimizeSchema(subfolder)).isEmpty() && SchemaValidator.isValid(subfolder)) {
            filePath = filePath.resolve(subfolder);
        }
        return filePath;
    }

    public Path resolveConfigBasedJsonFilePath(String domain, ResourceLocation id) {
        String idPath;
        Path filePath = this.resolveConfigSubfolderPath(domain);
        String idNamespace = SchemaValidator.minimizeSchema(id.m_135827_());
        if (!idNamespace.isEmpty() && SchemaValidator.isValid(idNamespace)) {
            filePath = filePath.resolve(idNamespace);
        }
        if ((idPath = id.m_135815_()).isEmpty() || !SchemaValidator.isValid(idPath)) {
            throw new IllegalStateException("Invalid storable ID!");
        }
        filePath = filePath.resolve(SchemaValidator.minimizeSchema(idPath) + ".json");
        return filePath;
    }
}

