/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.lazyio;

import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.FireplaceLibConstants;
import dev.the_fireplace.lib.api.io.injectables.ConfigBasedStorageReader;
import dev.the_fireplace.lib.api.io.injectables.ConfigBasedStorageWriter;
import dev.the_fireplace.lib.api.io.interfaces.access.SimpleBuffer;
import dev.the_fireplace.lib.api.lazyio.injectables.ConfigStateManager;
import dev.the_fireplace.lib.api.lazyio.injectables.ReloadableManager;
import dev.the_fireplace.lib.api.lazyio.interfaces.Config;
import dev.the_fireplace.lib.api.lazyio.interfaces.Reloadable;
import dev.the_fireplace.lib.domain.io.JsonBufferDiffGenerator;
import dev.the_fireplace.lib.io.access.JsonStorageWriteBuffer;
import dev.the_fireplace.lib.io.access.SchemaValidator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@Implementation
public final class ConfigStateManagerImpl
implements ConfigStateManager {
    private final ConfigBasedStorageReader storageReader;
    private final ConfigBasedStorageWriter storageWriter;
    private final ReloadableManager reloadableManager;
    private final JsonBufferDiffGenerator bufferDiffGenerator;
    private final ConcurrentMap<Config, Reloadable> configReloadables;

    @Inject
    public ConfigStateManagerImpl(ConfigBasedStorageReader storageReader, ConfigBasedStorageWriter storageWriter, ReloadableManager reloadableManager, JsonBufferDiffGenerator bufferDiffGenerator) {
        this.storageReader = storageReader;
        this.storageWriter = storageWriter;
        this.reloadableManager = reloadableManager;
        this.bufferDiffGenerator = bufferDiffGenerator;
        this.configReloadables = new ConcurrentHashMap<Config, Reloadable>();
    }

    @Override
    public <T extends Config> T initialize(T config) {
        this.load(config);
        this.save(config);
        this.registerReloadable(config);
        return config;
    }

    private <T extends Config> void registerReloadable(final T config) {
        String configId;
        String subFolder;
        final StringBuilder reloadGroup = new StringBuilder();
        String string = subFolder = SchemaValidator.isValid(config.getSubfolderName()) ? SchemaValidator.minimizeSchema(config.getSubfolderName()) : "";
        if (!subFolder.isEmpty()) {
            reloadGroup.append(subFolder).append("/");
        }
        String string2 = configId = SchemaValidator.isValid(config.getId()) ? SchemaValidator.minimizeSchema(config.getId()) : "";
        if (!configId.isEmpty()) {
            reloadGroup.append(configId);
        }
        if (!reloadGroup.toString().isEmpty()) {
            Reloadable reloadable = new Reloadable(){

                @Override
                public void reload() {
                    JsonStorageWriteBuffer previousState = new JsonStorageWriteBuffer();
                    config.writeTo(previousState);
                    ConfigStateManagerImpl.this.reload(config);
                    JsonStorageWriteBuffer currentState = new JsonStorageWriteBuffer();
                    config.writeTo(currentState);
                    SimpleBuffer diffBuffer = ConfigStateManagerImpl.this.bufferDiffGenerator.generateLeftDiff(previousState, currentState);
                    config.afterReload(diffBuffer);
                }

                @Override
                public String getReloadGroup() {
                    return reloadGroup.toString();
                }
            };
            this.configReloadables.put(config, reloadable);
            this.reloadableManager.register(reloadable);
        } else {
            FireplaceLibConstants.getLogger().warn("Config was registered without ID or Subfolder, unable to register reloadable!", (Throwable)new Exception("Stacktrace"));
        }
    }

    @Override
    public void load(Config config) {
        this.storageReader.readTo(config);
    }

    @Override
    public void reload(Config config) {
        this.load(config);
    }

    @Override
    public void save(Config config) {
        this.storageWriter.write(config);
    }

    @Override
    public void delete(Config config) {
        this.tearDown(config);
        this.storageWriter.delete(config);
    }

    private void tearDown(Config config) {
        Reloadable reloadable = (Reloadable)this.configReloadables.remove(config);
        if (reloadable != null) {
            this.reloadableManager.unregister(reloadable);
        }
    }
}

