/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.lazyio;

import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.api.io.injectables.SaveBasedStorageReader;
import dev.the_fireplace.lib.api.io.injectables.SaveBasedStorageWriter;
import dev.the_fireplace.lib.api.lazyio.injectables.SaveDataStateManager;
import dev.the_fireplace.lib.api.lazyio.injectables.SaveTimer;
import dev.the_fireplace.lib.api.lazyio.interfaces.Defaultable;
import dev.the_fireplace.lib.api.lazyio.interfaces.SaveData;
import dev.the_fireplace.lib.api.multithreading.injectables.ExecutionManager;
import dev.the_fireplace.lib.lazyio.SaveDataState;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@Implementation
public final class SaveDataStateManagerImpl
implements SaveDataStateManager {
    private final SaveBasedStorageReader storageReader;
    private final SaveBasedStorageWriter storageWriter;
    private final SaveTimer saveTimer;
    private final ExecutionManager executionManager;
    private final ConcurrentMap<String, SaveDataState> dataStates = new ConcurrentHashMap<String, SaveDataState>(1);

    @Inject
    public SaveDataStateManagerImpl(SaveBasedStorageReader storageReader, SaveBasedStorageWriter storageWriter, SaveTimer saveTimer, ExecutionManager executionManager) {
        this.storageReader = storageReader;
        this.storageWriter = storageWriter;
        this.saveTimer = saveTimer;
        this.executionManager = executionManager;
    }

    @Override
    public void initializeWithAutosave(SaveData saveData, short saveIntervalInMinutes) {
        if (saveIntervalInMinutes <= 0) {
            throw new IllegalArgumentException("Save interval must be greater than 0!");
        }
        Runnable autosaveRunnable = () -> this.save(saveData);
        this.dataStates.put(SaveDataStateManagerImpl.getStateKey(saveData), new SaveDataState(saveIntervalInMinutes, autosaveRunnable));
        this.initialize(saveData);
        this.saveTimer.register(saveIntervalInMinutes, autosaveRunnable);
    }

    @Override
    public void initializeWithoutAutosave(SaveData saveData) {
        this.dataStates.put(SaveDataStateManagerImpl.getStateKey(saveData), new SaveDataState(0, null));
        this.initialize(saveData);
        if (SaveDataStateManagerImpl.isNonDefault(saveData)) {
            this.forceSave(saveData);
        }
    }

    private void initialize(SaveData saveData) {
        this.load(saveData);
        if (SaveDataStateManagerImpl.isNotDefaultable(saveData) || !this.storageReader.isStored(saveData)) {
            this.markChanged(saveData);
        }
    }

    @Override
    public void markChanged(SaveData saveData) {
        this.getState((SaveData)saveData).isChanged.lazySet(true);
    }

    @Override
    public void load(SaveData saveData) {
        this.storageReader.readTo(saveData);
    }

    @Override
    public void save(SaveData saveData) {
        if (this.canSave(saveData)) {
            this.forceSave(saveData);
        }
    }

    private boolean canSave(SaveData saveData) {
        SaveDataState state = this.getState(saveData);
        return state.isChanged.get() && !state.saving.get();
    }

    @Override
    public void forceSave(SaveData saveData) {
        SaveDataState state = this.getState(saveData);
        state.saving.set(true);
        state.isChanged.set(false);
        this.executionManager.run(() -> {
            this.storageWriter.write(saveData);
            state.saving.set(false);
        });
    }

    @Override
    public void tearDown(SaveData saveData) {
        String key = SaveDataStateManagerImpl.getStateKey(saveData);
        if (this.dataStates.containsKey(key)) {
            SaveDataState state = (SaveDataState)this.dataStates.get(key);
            if (state.autosaveInterval > 0 && state.autosaveRunnable != null) {
                this.saveTimer.unregister(state.autosaveInterval, state.autosaveRunnable);
            }
            this.dataStates.remove(key);
        }
    }

    @Override
    public void delete(SaveData saveData) {
        this.tearDown(saveData);
        this.storageWriter.delete(saveData);
    }

    private SaveDataState getState(SaveData saveData) {
        SaveDataState state = (SaveDataState)this.dataStates.get(SaveDataStateManagerImpl.getStateKey(saveData));
        if (state == null) {
            throw new IllegalStateException("Save data state not found!");
        }
        return state;
    }

    private static String getStateKey(SaveData saveData) {
        return saveData.getDatabase() + "-" + saveData.getTable() + "-" + saveData.getId();
    }

    private static boolean isNonDefault(Object obj) {
        return SaveDataStateManagerImpl.isNotDefaultable(obj) || !((Defaultable)obj).isDefault();
    }

    private static boolean isNotDefaultable(Object obj) {
        return !(obj instanceof Defaultable);
    }
}

