/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.lazyio.hierarchicalconfig;

import dev.the_fireplace.lib.FireplaceLibConstants;
import dev.the_fireplace.lib.api.lazyio.injectables.ReloadableManager;
import dev.the_fireplace.lib.api.lazyio.interfaces.HierarchicalConfig;
import dev.the_fireplace.lib.api.lazyio.interfaces.NamespacedHierarchicalConfigManager;
import dev.the_fireplace.lib.api.lazyio.interfaces.Reloadable;
import dev.the_fireplace.lib.io.access.JsonStoragePath;
import dev.the_fireplace.lib.lazyio.hierarchicalconfig.HierarchicalConfigLoader;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;

public class NamespacedHierarchicalConfigManagerImpl<T extends HierarchicalConfig>
implements NamespacedHierarchicalConfigManager<T> {
    protected final HierarchicalConfigLoader configLoader;
    protected final JsonStoragePath jsonStoragePath;
    protected final ReloadableManager reloadableManager;
    protected final String domain;
    protected final T defaultConfig;
    protected final Iterable<ResourceLocation> allowedModuleIds;
    protected final Map<ResourceLocation, T> modules;

    public NamespacedHierarchicalConfigManagerImpl(String domain, T defaultConfig, Iterable<ResourceLocation> allowedModuleIds, HierarchicalConfigLoader configLoader, JsonStoragePath jsonStoragePath, ReloadableManager reloadableManager) {
        this.domain = domain;
        this.defaultConfig = defaultConfig;
        this.allowedModuleIds = allowedModuleIds;
        this.modules = new ConcurrentHashMap<ResourceLocation, T>();
        this.configLoader = configLoader;
        this.jsonStoragePath = jsonStoragePath;
        this.reloadableManager = reloadableManager;
        this.loadExistingHierarchy(allowedModuleIds);
        this.registerHierarchyReloadable();
    }

    protected void loadExistingHierarchy(Iterable<ResourceLocation> allowedModuleIds) {
        for (ResourceLocation id : allowedModuleIds) {
            Path filePath = this.jsonStoragePath.resolveConfigBasedJsonFilePath(this.domain, id);
            if (!filePath.toFile().exists() || this.modules.containsKey(id)) continue;
            HierarchicalConfig module = this.defaultConfig.clone();
            try {
                this.addCustom(id, module);
            }
            catch (ClassCastException exception) {
                FireplaceLibConstants.getLogger().error("Cloned hierarchical config was not of the expected type!", (Throwable)exception);
            }
        }
    }

    protected void registerHierarchyReloadable() {
        this.reloadableManager.register(new Reloadable(){

            @Override
            public void reload() {
                NamespacedHierarchicalConfigManagerImpl.this.loadExistingHierarchy(NamespacedHierarchicalConfigManagerImpl.this.getAllowedModuleIds());
            }

            @Override
            public String getReloadGroup() {
                return NamespacedHierarchicalConfigManagerImpl.this.domain;
            }
        });
    }

    @Override
    public Iterable<ResourceLocation> getAllowedModuleIds() {
        return this.allowedModuleIds;
    }

    @Override
    public T get(ResourceLocation moduleId) {
        return (T)((HierarchicalConfig)this.modules.getOrDefault(moduleId, this.defaultConfig));
    }

    @Override
    public Collection<ResourceLocation> getCustoms() {
        return Set.copyOf(this.modules.keySet());
    }

    @Override
    public boolean isCustom(ResourceLocation moduleId) {
        return this.modules.containsKey(moduleId);
    }

    @Override
    public void addCustom(ResourceLocation moduleId, T module) {
        this.modules.put(moduleId, module);
        this.configLoader.initialize(module, this.domain, moduleId);
    }

    @Override
    public boolean deleteCustom(ResourceLocation moduleId) {
        HierarchicalConfig module = (HierarchicalConfig)this.modules.remove(moduleId);
        if (module == null) {
            return false;
        }
        return this.configLoader.delete(this.domain, moduleId);
    }

    @Override
    public void saveAllCustoms() {
        for (Map.Entry<ResourceLocation, T> moduleEntry : this.modules.entrySet()) {
            this.configLoader.save((HierarchicalConfig)moduleEntry.getValue(), this.domain, moduleEntry.getKey());
        }
    }

    @Override
    public void saveCustom(ResourceLocation id) {
        HierarchicalConfig module = (HierarchicalConfig)this.modules.get(id);
        if (module == null) {
            FireplaceLibConstants.getLogger().error("Custom config does not exist, and cannot be saved: " + String.valueOf(id));
            return;
        }
        this.configLoader.save(module, this.domain, id);
    }
}

