/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.math;

final class MathParser {
    private int currentPosition = -1;
    private int currentCharacter;
    private final String formula;

    MathParser(String formula) {
        this.formula = formula;
    }

    private void nextChar() {
        this.currentCharacter = ++this.currentPosition < this.formula.length() ? (int)this.formula.charAt(this.currentPosition) : -1;
    }

    private boolean eat(int charToEat) {
        while (this.currentCharacter == 32) {
            this.nextChar();
        }
        if (this.currentCharacter == charToEat) {
            this.nextChar();
            return true;
        }
        return false;
    }

    double parse() {
        this.nextChar();
        double x = this.parseExpression();
        if (this.currentPosition < this.formula.length()) {
            throw new RuntimeException("Unexpected: " + (char)this.currentCharacter);
        }
        return x;
    }

    private double parseExpression() {
        double x = this.parseTerm();
        while (true) {
            if (this.eat(43)) {
                x += this.parseTerm();
                continue;
            }
            if (!this.eat(45)) break;
            x -= this.parseTerm();
        }
        return x;
    }

    private double parseTerm() {
        double x = this.parseFactor();
        while (true) {
            if (this.eat(42)) {
                x *= this.parseFactor();
                continue;
            }
            if (!this.eat(47)) break;
            x /= this.parseFactor();
        }
        return x;
    }

    private double parseFactor() {
        double x;
        if (this.eat(43)) {
            return this.parseFactor();
        }
        if (this.eat(45)) {
            return -this.parseFactor();
        }
        int startPos = this.currentPosition;
        if (this.eat(40)) {
            x = this.parseExpression();
            this.eat(41);
        } else if (this.isNumberCharacter()) {
            this.navigatePastNumber();
            x = Double.parseDouble(this.formula.substring(startPos, this.currentPosition));
        } else if (this.isLetter()) {
            this.navigatePastFunctionName();
            String func = this.formula.substring(startPos, this.currentPosition);
            x = this.parseFactor();
            x = this.performFunction(x, func);
        } else {
            throw new RuntimeException("Unexpected: " + (char)this.currentCharacter);
        }
        if (this.eat(94)) {
            x = Math.pow(x, this.parseFactor());
        }
        return x;
    }

    private boolean isNumberCharacter() {
        return this.isNumeric() || this.currentCharacter == 46;
    }

    private boolean isNumeric() {
        return this.currentCharacter >= 48 && this.currentCharacter <= 57;
    }

    private boolean isLetter() {
        return this.currentCharacter >= 97 && this.currentCharacter <= 122;
    }

    private void navigatePastNumber() {
        while (this.isNumberCharacter()) {
            this.nextChar();
        }
    }

    private void navigatePastFunctionName() {
        while (this.isLetter()) {
            this.nextChar();
        }
    }

    private double performFunction(double x, String func) {
        switch (func) {
            case "sqrt": {
                x = Math.sqrt(x);
                break;
            }
            case "sin": {
                x = Math.sin(Math.toRadians(x));
                break;
            }
            case "cos": {
                x = Math.cos(Math.toRadians(x));
                break;
            }
            case "tan": {
                x = Math.tan(Math.toRadians(x));
                break;
            }
            default: {
                throw new RuntimeException("Unknown function: " + func);
            }
        }
        return x;
    }
}

