/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.network;

import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.api.network.injectables.PacketSpecificationRegistry;
import dev.the_fireplace.lib.api.network.interfaces.ClientboundPacketReceiver;
import dev.the_fireplace.lib.api.network.interfaces.ClientboundPacketSpecification;
import dev.the_fireplace.lib.api.network.interfaces.PacketSpecification;
import dev.the_fireplace.lib.api.network.interfaces.ServerboundPacketReceiver;
import dev.the_fireplace.lib.api.network.interfaces.ServerboundPacketSpecification;
import dev.the_fireplace.lib.domain.network.ReceiveClientPacket;
import dev.the_fireplace.lib.domain.network.SimpleChannelManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.inject.Singleton;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

@Singleton
@Implementation(allInterfaces=true)
public final class ForgePacketChannel
implements SimpleChannelManager,
PacketSpecificationRegistry {
    private final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("fireplacelib", "packets"), () -> "", version -> true, version -> true);
    private final Map<ResourceLocation, Supplier<ClientboundPacketReceiver>> clientReceivers = new ConcurrentHashMap<ResourceLocation, Supplier<ClientboundPacketReceiver>>();
    private final Map<ResourceLocation, Supplier<ServerboundPacketReceiver>> serverReceivers = new ConcurrentHashMap<ResourceLocation, Supplier<ServerboundPacketReceiver>>();
    private final ReceiveClientPacket receiveClientPacket;

    @Inject
    public ForgePacketChannel(ReceiveClientPacket receiveClientPacket) {
        this.receiveClientPacket = receiveClientPacket;
    }

    @Override
    public SimpleChannel getChannel() {
        return this.CHANNEL;
    }

    @Override
    public void register() {
        this.CHANNEL.registerMessage(1, ReceiverWrapper.class, (receiverWrapper, outputByteBuf) -> outputByteBuf.writeBytes((ByteBuf)receiverWrapper.buffer), x$0 -> new ReceiverWrapper((FriendlyByteBuf)x$0), ReceiverWrapper::read);
    }

    @Override
    public void register(ServerboundPacketSpecification specification) {
        this.serverReceivers.put(specification.getPacketID(), specification.getReceiverFactory());
    }

    @Override
    public void register(ClientboundPacketSpecification specification) {
        this.clientReceivers.put(specification.getPacketID(), specification.getReceiverFactory());
    }

    @Override
    public Object wrap(PacketSpecification specification, FriendlyByteBuf packetContents) {
        FriendlyByteBuf wrappedPacketContents = new FriendlyByteBuf(Unpooled.buffer());
        wrappedPacketContents.m_130085_(specification.getPacketID());
        wrappedPacketContents.writeBytes((ByteBuf)packetContents);
        return new ReceiverWrapper(wrappedPacketContents);
    }

    private class ReceiverWrapper {
        private final FriendlyByteBuf buffer;

        private ReceiverWrapper(FriendlyByteBuf buffer) {
            this.buffer = buffer;
        }

        public void read(Supplier<NetworkEvent.Context> contextSupplier) {
            ServerPlayer sender;
            NetworkEvent.Context context = contextSupplier.get();
            ResourceLocation packetId = this.buffer.m_130281_();
            FriendlyByteBuf packetContents = new FriendlyByteBuf(this.buffer.copy());
            Supplier<ClientboundPacketReceiver> clientReceiver = ForgePacketChannel.this.clientReceivers.get(packetId);
            Supplier<ServerboundPacketReceiver> serverReceiver = ForgePacketChannel.this.serverReceivers.get(packetId);
            ForgePacketChannel.this.receiveClientPacket.receiveClientPacket(clientReceiver, context, packetContents);
            if (serverReceiver != null && (sender = context.getSender()) != null) {
                context.enqueueWork(() -> ((ServerboundPacketReceiver)serverReceiver.get()).receive(sender.f_8924_, sender, sender.f_8906_, packetContents));
            }
            context.setPacketHandled(true);
        }
    }
}

