/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.network;

import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.api.network.injectables.PacketSender;
import dev.the_fireplace.lib.api.network.interfaces.PacketSpecification;
import dev.the_fireplace.lib.domain.network.ServerboundSender;
import dev.the_fireplace.lib.domain.network.SimpleChannelManager;
import javax.inject.Inject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

@Implementation
public final class ForgePacketSender
implements PacketSender {
    private final ServerboundSender serverboundSender;
    private final SimpleChannelManager simpleChannelManager;

    @Inject
    public ForgePacketSender(ServerboundSender serverboundSender, SimpleChannelManager simpleChannelManager) {
        this.serverboundSender = serverboundSender;
        this.simpleChannelManager = simpleChannelManager;
    }

    @Override
    public void sendToServer(PacketSpecification specification, FriendlyByteBuf packetContents) {
        this.serverboundSender.sendToServer(specification, packetContents);
    }

    @Override
    public void sendToClient(ServerGamePacketListenerImpl connection, PacketSpecification specification, FriendlyByteBuf packetContents) {
        SimpleChannel channel = this.simpleChannelManager.getChannel();
        if (channel.isRemotePresent(connection.m_6198_())) {
            channel.send(PacketDistributor.PLAYER.with(() -> connection.f_9743_), this.simpleChannelManager.wrap(specification, packetContents));
        } else if (!specification.shouldSilentlyFailOnMissingReceiver()) {
            throw new IllegalStateException(String.format("Player %s is missing a receiver for packet %s.", connection.f_9743_.m_36316_().getName(), specification.getPacketID().toString()));
        }
    }
}

