/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.network;

import dev.the_fireplace.lib.api.network.injectables.PacketSpecificationRegistry;
import dev.the_fireplace.lib.domain.translation.LocalizedClients;
import dev.the_fireplace.lib.network.ServerboundPackets;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class NetworkEvents {
    private final PacketSpecificationRegistry registry;
    private final ServerboundPackets serverboundPackets;
    private final LocalizedClients localizedClients;

    @Inject
    public NetworkEvents(PacketSpecificationRegistry registry, ServerboundPackets serverboundPackets, LocalizedClients localizedClients) {
        this.registry = registry;
        this.serverboundPackets = serverboundPackets;
        this.localizedClients = localizedClients;
    }

    public void init() {
        this.registry.register(this.serverboundPackets.clientConnected());
    }

    public void onDisconnected(UUID player) {
        this.localizedClients.removePlayer(player);
    }
}

