/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.player;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.FireplaceLibConstants;
import dev.the_fireplace.lib.api.player.injectables.GameProfileFinder;
import dev.the_fireplace.lib.api.uuid.injectables.EmptyUUID;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.GameProfileCache;

@Implementation(environment="SERVER")
public final class DedicatedServerGameProfileFinder
implements GameProfileFinder {
    private final EmptyUUID emptyUUID;
    private final GameProfileCache userCache;
    private final MinecraftSessionService sessionService;
    private final Set<UUID> uuidsWithoutProfiles = new HashSet<UUID>();
    private final Set<String> namesWithoutProfiles = new HashSet<String>();

    @Inject
    public DedicatedServerGameProfileFinder(EmptyUUID emptyUUID) {
        this.emptyUUID = emptyUUID;
        MinecraftServer server = FireplaceLibConstants.getServer();
        this.userCache = server.m_129927_();
        this.sessionService = server.m_129925_();
    }

    @Override
    public Optional<GameProfile> findProfile(UUID playerId) {
        if (this.emptyUUID.is(playerId)) {
            return Optional.empty();
        }
        if (this.uuidsWithoutProfiles.contains(playerId)) {
            return Optional.empty();
        }
        Optional cachedProfile = this.userCache.m_11002_(playerId);
        if (cachedProfile.isPresent()) {
            return cachedProfile;
        }
        GameProfile profile = new GameProfile(playerId, "");
        if ((profile = this.sessionService.fillProfileProperties(profile, false)).getName().isEmpty()) {
            this.uuidsWithoutProfiles.add(playerId);
            return Optional.empty();
        }
        this.userCache.m_10991_(profile);
        return Optional.of(profile);
    }

    @Override
    public Optional<GameProfile> findProfile(String playerName) {
        if (this.namesWithoutProfiles.contains(playerName) || playerName.isEmpty()) {
            return Optional.empty();
        }
        GameProfileCache.m_11004_((boolean)true);
        Optional profile = this.userCache.m_10996_(playerName);
        if (profile.isEmpty()) {
            this.namesWithoutProfiles.add(playerName);
        }
        return profile;
    }
}

