/*
 * Decompiled with CFR 0.152.
 */
package com.mining.oreminerx;

import com.mining.oreminerx.OREMinerXCommand;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.plugin.java.JavaPlugin;

public class OREMinerX
extends JavaPlugin
implements Listener {
    private Map<UUID, Boolean> toggledPlayers = new HashMap<UUID, Boolean>();
    private Set<Material> mineableOres = new HashSet<Material>();
    private int maxVeinSize;
    private boolean requirePermission;
    private boolean damageTools;
    private boolean dropExperience;

    @Override
    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfiguration();
        this.getServer().getPluginManager().registerEvents(this, this);
        this.getCommand("oreminerx").setExecutor(new OREMinerXCommand(this));
        this.getLogger().info("OREMinerX has been enabled!");
    }

    @Override
    public void onDisable() {
        this.getLogger().info("OREMinerX has been disabled!");
    }

    public void loadConfiguration() {
        FileConfiguration config = this.getConfig();
        List<String> oreStrings = config.getStringList("mineable-ores");
        this.mineableOres.clear();
        for (String oreName : oreStrings) {
            try {
                Material material = Material.valueOf(oreName.toUpperCase());
                this.mineableOres.add(material);
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warning("Unknown material in config: " + oreName);
            }
        }
        this.maxVeinSize = config.getInt("max-vein-size", 64);
        this.requirePermission = config.getBoolean("require-permission", true);
        this.damageTools = config.getBoolean("damage-tools", true);
        this.dropExperience = config.getBoolean("drop-experience", true);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        if (!this.toggledPlayers.getOrDefault(player.getUniqueId(), false).booleanValue()) {
            return;
        }
        if (this.requirePermission && !player.hasPermission("oreminerx.use")) {
            return;
        }
        if (!this.mineableOres.contains(block.getType())) {
            return;
        }
        ItemStack tool = player.getInventory().getItemInMainHand();
        if (!this.isValidTool(tool, block.getType())) {
            return;
        }
        Set<Block> veinBlocks = this.findVeinBlocks(block, new HashSet<Block>());
        if (veinBlocks.size() > 1) {
            event.setCancelled(true);
            this.mineVein(player, veinBlocks, tool, event.getExpToDrop());
        }
    }

    private boolean isValidTool(ItemStack tool, Material blockType) {
        if (tool == null || tool.getType() == Material.AIR) {
            return false;
        }
        String toolType = tool.getType().name();
        boolean isPickaxe = toolType.endsWith("_PICKAXE");
        return isPickaxe;
    }

    private Set<Block> findVeinBlocks(Block startBlock, Set<Block> visitedBlocks) {
        if (visitedBlocks.size() >= this.maxVeinSize) {
            return visitedBlocks;
        }
        if (visitedBlocks.contains(startBlock) || !this.mineableOres.contains(startBlock.getType())) {
            return visitedBlocks;
        }
        Material targetType = startBlock.getType();
        visitedBlocks.add(startBlock);
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    Block adjacentBlock;
                    if (Math.abs(dx) + Math.abs(dy) + Math.abs(dz) > 1 || (adjacentBlock = startBlock.getRelative(dx, dy, dz)).getType() != targetType) continue;
                    this.findVeinBlocks(adjacentBlock, visitedBlocks);
                }
            }
        }
        return visitedBlocks;
    }

    private void mineVein(Player player, Set<Block> blocks, ItemStack tool, int baseExp) {
        int blocksBroken = 0;
        for (Block block : blocks) {
            if (tool.getType() == Material.AIR) break;
            Collection<ItemStack> drops = block.getDrops(tool);
            block.setType(Material.AIR);
            for (ItemStack drop : drops) {
                player.getWorld().dropItemNaturally(block.getLocation(), drop);
            }
            if (this.dropExperience) {
                player.giveExp(baseExp);
            }
            ++blocksBroken;
            if (!this.damageTools) continue;
            this.damageTool(tool, player);
        }
        player.sendMessage("\u00a7a[OREMinerX] \u00a77Mined " + blocksBroken + " blocks!");
    }

    private void damageTool(ItemStack tool, Player player) {
        if (tool.getItemMeta() instanceof Damageable) {
            Damageable damageable = (Damageable)tool.getItemMeta();
            int damage = damageable.getDamage();
            short maxDurability = tool.getType().getMaxDurability();
            damageable.setDamage(++damage);
            if (damage >= maxDurability) {
                player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
                player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
            } else {
                tool.setItemMeta(damageable);
            }
        }
    }

    public void toggleMiner(Player player) {
        UUID playerUuid;
        boolean currentState = this.toggledPlayers.getOrDefault(playerUuid = player.getUniqueId(), false);
        this.toggledPlayers.put(playerUuid, !currentState);
        if (!currentState) {
            player.sendMessage("\u00a7a[OREMinerX] \u00a77Vein mining enabled!");
        } else {
            player.sendMessage("\u00a7c[OREMinerX] \u00a77Vein mining disabled!");
        }
    }

    public boolean isToggled(Player player) {
        return this.toggledPlayers.getOrDefault(player.getUniqueId(), false);
    }
}

