/*
 * Decompiled with CFR 0.152.
 */
package one.laqua.waig.client;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElement;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_746;
import net.minecraft.class_9779;
import one.laqua.waig.client.config.WaigConfig;
import one.laqua.waig.mixin.BossBarHudAccessor;
import one.laqua.waig.mixin.EquipmentAccessor;

@Environment(value=EnvType.CLIENT)
public class CompassHud
implements HudElement {
    private static final String compass_text_simple = "S . . . . . . . SW . . . . . . . W . . . . . . . NW . . . . . . . N . . . . . . . NE . . . . . . . E . . . . . . . SE . . . . . . . ";
    private static final String compass_text_triple = "S . . . . . . . SW . . . . . . . W . . . . . . . NW . . . . . . . N . . . . . . . NE . . . . . . . E . . . . . . . SE . . . . . . . S . . . . . . . SW . . . . . . . W . . . . . . . NW . . . . . . . N . . . . . . . NE . . . . . . . E . . . . . . . SE . . . . . . . S . . . . . . . SW . . . . . . . W . . . . . . . NW . . . . . . . N . . . . . . . NE . . . . . . . E . . . . . . . SE . . . . . . . ";
    private static final int oneSideLength = 20;
    private static final Set<Integer> compass_stacks = WaigConfig.getCompassItems();
    private static boolean visible = true;

    public void render(class_332 context, class_9779 tickCounter) {
        if (!visible) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1690.field_1842) {
            return;
        }
        class_746 p = client.field_1724;
        if (p == null) {
            return;
        }
        switch (WaigConfig.getHudShowMode()) {
            case ALWAYS: {
                break;
            }
            case INVENTORY: {
                boolean containsCompass;
                HashSet<Integer> compassIds = new HashSet<Integer>(compass_stacks);
                Set inventory = Stream.concat(p.method_31548().method_67533().stream(), class_1661.field_56551.values().stream().map(slot -> ((EquipmentAccessor)p.method_31548()).getEquipment().method_66659(slot))).map(class_1799::method_7909).map(class_1792::method_7880).collect(Collectors.toSet());
                compassIds.retainAll(inventory);
                boolean bl = containsCompass = !compassIds.isEmpty();
                if (containsCompass) break;
                return;
            }
            case HAND: {
                boolean holdsCompass;
                boolean bl = holdsCompass = WaigConfig.getCompassItems().contains(class_1792.method_7880((class_1792)p.method_6079().method_7909())) || WaigConfig.getCompassItems().contains(class_1792.method_7880((class_1792)p.method_6047().method_7909()));
                if (holdsCompass) break;
                return;
            }
        }
        float modYaw = (p.field_6241 % 360.0f + 360.0f) % 360.0f;
        String renderText = CompassHud.displayedText(modYaw);
        int screenWidth = client.method_22683().method_4486();
        class_327 textRenderer = client.field_1705.method_1756();
        int textWidthInPixels = textRenderer.method_1727(renderText);
        int posX = screenWidth / 2 - textWidthInPixels / 2 - 2;
        int bossBarCount = ((BossBarHudAccessor)client.field_1705.method_1740()).getBossBars().size();
        int posY = 3 + bossBarCount * 19;
        context.method_25303(textRenderer, renderText, posX, posY, -1);
    }

    private static String displayedText(float yaw) {
        int textAnchor = Math.round(yaw / 360.0f * (float)compass_text_simple.length()) + compass_text_simple.length();
        return compass_text_triple.substring(textAnchor - 20, textAnchor + 20);
    }

    public static void setVisible(boolean visible) {
        CompassHud.visible = visible;
    }

    public static void toggleVisibility() {
        CompassHud.setVisible(!visible);
    }
}

