/*
 * Decompiled with CFR 0.152.
 */
package one.laqua.waig.client.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import one.laqua.waig.client.WaigClient;
import one.laqua.waig.client.config.HudShowMode;
import org.apache.logging.log4j.Level;

public class WaigConfig {
    private static final String CONFIG_FILE = "config/waig.config";
    private static final String KEY_HUD_SHOW_MODE = "hud-show-mode";
    private static final String KEY_COMPASS_ITEMS = "compass-items";
    private static final String DEFAULT_COMPASS_ID = "minecraft:compass";
    private static HudShowMode hudShowMode = HudShowMode.ALWAYS;
    private static Set<Integer> compassItems = Set.of(Integer.valueOf(class_1792.method_7880((class_1792)class_1802.field_8251)));

    public static HudShowMode getHudShowMode() {
        return hudShowMode;
    }

    public static Set<Integer> getCompassItems() {
        return compassItems;
    }

    public static boolean readConfigFile() {
        Path filePath = Path.of(CONFIG_FILE, new String[0]);
        if (!Files.exists(filePath, new LinkOption[0]) && !WaigConfig.generateDefaultConfigFile()) {
            return false;
        }
        try {
            Scanner scanner = new Scanner(filePath);
            while (scanner.hasNextLine()) {
                String[] pieces;
                String line = scanner.nextLine();
                if (line.strip().startsWith("#") || (pieces = line.split("=", 2)).length != 2) continue;
                String key = pieces[0].strip().toLowerCase();
                if (key.equals(KEY_HUD_SHOW_MODE)) {
                    String value = pieces[1].strip().toUpperCase();
                    try {
                        hudShowMode = HudShowMode.valueOf(value);
                    }
                    catch (IllegalArgumentException e) {
                        WaigClient.log(Level.ERROR, "The value '" + pieces[1].strip() + "' for config key 'hud-show-mode' is invalid. Possible values are: " + Arrays.toString((Object[])HudShowMode.values()).toLowerCase() + ". Falling back to default value '" + HudShowMode.ALWAYS.name().toLowerCase() + "'.");
                        return false;
                    }
                }
                if (!key.equals(KEY_COMPASS_ITEMS)) continue;
                String[] potentialItems = pieces[1].strip().toLowerCase().split(",");
                Set configItems = Arrays.stream(potentialItems).filter(potentialItemId -> potentialItemId.contains(":")).map(potentialItemId -> {
                    boolean containsInvalidChars;
                    String[] idPieces = potentialItemId.split(":");
                    boolean bl = containsInvalidChars = !Stream.of(idPieces).map(String::strip).allMatch(s -> s.matches("[a-z0-9/._-]*"));
                    if (containsInvalidChars) {
                        WaigClient.log(Level.ERROR, "The config value '" + potentialItemId + "' contains illegal characters and cannot be parsed into an item. Please check the config file for errors. Ignoring this value.");
                        return class_1792.method_7880((class_1792)class_1802.field_8162);
                    }
                    class_2960 itemIdentifier = class_2960.method_60655((String)idPieces[0].strip(), (String)idPieces[1].strip());
                    return class_1792.method_7880((class_1792)((class_1792)class_7923.field_41178.method_63535(itemIdentifier)));
                }).filter(item -> !item.equals(class_1792.method_7880((class_1792)class_1802.field_8162))).collect(Collectors.toSet());
                if (!configItems.isEmpty()) {
                    compassItems = configItems;
                    continue;
                }
                WaigClient.log(Level.WARN, "The config key 'compass-items' is present, but no values were configured. Defaulting to minecraft:compass.");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean generateDefaultConfigFile() {
        Path filePath = Path.of(CONFIG_FILE, new String[0]);
        try {
            Files.write(filePath, List.of(new String[]{"# WAIG config file", "", "# hud show mode, defaults to " + HudShowMode.ALWAYS.name().toLowerCase(), "# possible values are: " + Arrays.toString((Object[])HudShowMode.values()).toLowerCase(), "hud-show-mode = " + HudShowMode.ALWAYS.name().toLowerCase(), "", "# list of valid compass items, defaults to minecraft:compass", "# use the namespaced identifiers of items and use a colon as a separator", "# separate list items with commas", "compass-items = minecraft:compass"}), new OpenOption[0]);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

