/*
 * Decompiled with CFR 0.152.
 */
package dtteam.dtru.genfeature;

import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.systems.genfeature.GenFeature;
import com.dtteam.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.species.Species;
import dtteam.dtru.block.TransitionLogBranchBlock;
import dtteam.dtru.tree.BrimwoodFamily;
import dtteam.dtru.tree.TransitionLogFamily;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class MagmaBottomGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Integer> MIN_HEIGHT = ConfigurationProperty.integer((String)"min_height");
    public static final ConfigurationProperty<Integer> MAX_HEIGHT = ConfigurationProperty.integer((String)"max_height");

    public MagmaBottomGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{MIN_HEIGHT, MAX_HEIGHT});
    }

    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(MIN_HEIGHT, (Object)3)).with(MAX_HEIGHT, (Object)5);
    }

    public boolean shouldApply(Species species, GenFeatureConfiguration configuration) {
        return species.getFamily() instanceof BrimwoodFamily;
    }

    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        BlockPos trunkPos;
        BlockState trunkState;
        int height = context.random().nextInt(((Integer)configuration.get(MIN_HEIGHT)).intValue(), (Integer)configuration.get(MAX_HEIGHT) + 1);
        LevelAccessor level = context.level();
        for (int i = 1; i < height; ++i) {
            BlockPos trunkPos2 = context.pos().above(i);
            int rad = TreeHelper.getRadius((BlockGetter)level, (BlockPos)trunkPos2);
            if (rad == 0) continue;
            ((BrimwoodFamily)context.species().getFamily()).getMagmaBranch().ifPresent(sb -> sb.setRadius(level, trunkPos2, rad, Direction.UP));
        }
        if (context.species().getFamily() instanceof TransitionLogFamily && (trunkState = level.getBlockState(trunkPos = context.pos().above(height))).hasProperty((Property)TransitionLogBranchBlock.TRANSITION)) {
            level.setBlock(trunkPos, (BlockState)trunkState.setValue((Property)TransitionLogBranchBlock.TRANSITION, (Comparable)Boolean.valueOf(true)), 2);
        }
        return true;
    }
}

