/*
 * Decompiled with CFR 0.152.
 */
package dtteam.dtru.growthlogic;

import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.systems.GrowSignal;
import com.dtteam.dynamictrees.systems.growthlogic.GrowthLogicKitConfiguration;
import com.dtteam.dynamictrees.systems.growthlogic.context.DirectionManipulationContext;
import com.dtteam.dynamictrees.tree.TreeHelper;
import dtteam.dtru.growthlogic.VariateHeightLogic;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class TwistingTreeLogic
extends VariateHeightLogic {
    public static final ConfigurationProperty<Float> CHANCE_TO_SPLIT = ConfigurationProperty.floatProperty((String)"chance_to_split");
    public static final ConfigurationProperty<Integer> DOWN_PROBABILITY = ConfigurationProperty.integer((String)"down_probability");
    public static final ConfigurationProperty<Boolean> SPLIT_ENDS = ConfigurationProperty.bool((String)"split_ends");

    public TwistingTreeLogic(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(CHANCE_TO_SPLIT, (Object)Float.valueOf(0.01f))).with(DOWN_PROBABILITY, (Object)0)).with(HEIGHT_VARIATION, (Object)3)).with(SPLIT_ENDS, (Object)true);
    }

    @Override
    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{CHANCE_TO_SPLIT, DOWN_PROBABILITY, SPLIT_ENDS, HEIGHT_VARIATION, LOWEST_BRANCH_VARIATION});
    }

    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        boolean shouldSplit;
        Level level = context.level();
        GrowSignal signal = context.signal();
        int[] probMap = context.probMap();
        BlockPos pos = context.pos();
        Direction originDir = signal.dir.getOpposite();
        int count = this.validSurroundingBranches((LevelAccessor)level, pos, originDir, (dir, rad) -> {
            probMap[dir.ordinal()] = rad;
        });
        boolean bl = shouldSplit = level.getRandom().nextFloat() < ((Float)configuration.get(CHANCE_TO_SPLIT)).floatValue();
        if (shouldSplit) {
            for (Direction dir2 : Direction.values()) {
                int n = dir2.ordinal();
                probMap[n] = probMap[n] + 1;
            }
        }
        if (count == 0 || ((Boolean)configuration.get(SPLIT_ENDS)).booleanValue() && signal.energy < 3.0f) {
            probMap[0] = (Integer)configuration.get(DOWN_PROBABILITY);
            probMap[1] = context.species().getUpProbability();
            probMap[5] = 1;
            probMap[4] = 1;
            probMap[3] = 1;
            probMap[2] = 1;
        }
        probMap[originDir.ordinal()] = 0;
        return probMap;
    }

    protected int validSurroundingBranches(LevelAccessor level, BlockPos pos, Direction originDir, BiConsumer<Direction, Integer> runForValidDirs) {
        int count = 0;
        for (Direction direction : Direction.values()) {
            int rad;
            if (direction == originDir || (rad = TreeHelper.getRadius((BlockGetter)level, (BlockPos)pos.offset(direction.getNormal()))) <= 0) continue;
            ++count;
            runForValidDirs.accept(direction, rad);
        }
        return count;
    }
}

