/*
 * Decompiled with CFR 0.152.
 */
package dtteam.dtru.growthlogic;

import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.systems.GrowSignal;
import com.dtteam.dynamictrees.systems.growthlogic.GrowthLogicKitConfiguration;
import com.dtteam.dynamictrees.systems.growthlogic.context.DirectionManipulationContext;
import com.dtteam.dynamictrees.systems.growthlogic.context.PositionalSpeciesContext;
import dtteam.dtru.growthlogic.VariateHeightLogic;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;

public class WillowLogic
extends VariateHeightLogic {
    public static final ConfigurationProperty<Integer> CANOPY_DEPTH = ConfigurationProperty.integer((String)"canopy_depth");

    public WillowLogic(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(CANOPY_DEPTH, (Object)4)).with(HEIGHT_VARIATION, (Object)8);
    }

    @Override
    protected void registerProperties() {
        super.registerProperties();
        this.register(new ConfigurationProperty[]{CANOPY_DEPTH});
    }

    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        GrowSignal signal = context.signal();
        int[] probMap = context.probMap();
        Direction originDir = signal.dir.getOpposite();
        probMap[Direction.DOWN.ordinal()] = 2;
        int lowestBranch = configuration.getLowestBranchHeight((PositionalSpeciesContext)context);
        if (signal.delta.getY() >= lowestBranch + (Integer)configuration.get(CANOPY_DEPTH)) {
            probMap[Direction.UP.ordinal()] = 0;
        }
        probMap[originDir.ordinal()] = 0;
        return probMap;
    }
}

