/*
 * Decompiled with CFR 0.152.
 */
package dtteam.dtru.init;

import com.dtteam.dynamictrees.tree.family.Family;
import dtteam.dtru.block.BambooBranchBlock;
import dtteam.dtru.tree.EucalyptusFamily;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;

@EventBusSubscriber(modid="dtru")
public class DTRUClient {
    public static void setup() {
        DTRUClient.registerRenderLayers();
    }

    private static void registerRenderLayers() {
        BuiltInRegistries.BLOCK.stream().filter(block -> block instanceof BambooBranchBlock).forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.cutoutMipped()));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    private static void registerColorHandlers(RegisterColorHandlersEvent.Block event) {
        int white = -1;
        int magenta = 0xFF00FF;
        for (EucalyptusFamily family : Family.REGISTRY.getAll().stream().filter(f -> f instanceof EucalyptusFamily).map(f -> (EucalyptusFamily)((Object)f)).collect(Collectors.toSet())) {
            family.getBranch().ifPresent(branchBlock -> event.register((state, level, pos, tintIndex) -> pos != null ? family.branchColorMultiplier(state, level, pos) : 0xFF00FF, new Block[]{branchBlock}));
            family.getSurfaceRoot().ifPresent(surfaceRoot -> event.register((state, level, pos, tintIndex) -> pos != null ? family.branchColorMultiplier(state, level, pos) : 0xFF00FF, new Block[]{surfaceRoot}));
        }
    }
}

