/*
 * Decompiled with CFR 0.152.
 */
package dtteam.dtru.tree;

import com.dtteam.dynamictrees.api.lazyvalue.MutableLazyValue;
import com.dtteam.dynamictrees.api.registry.TypedRegistry;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.branch.ThickBranchBlock;
import com.dtteam.dynamictrees.data.DTDataProvider;
import com.dtteam.dynamictrees.data.Generator;
import com.dtteam.dynamictrees.data.generator.BranchStateGenerator;
import com.dtteam.dynamictrees.data.provider.DTBlockStateProvider;
import com.dtteam.dynamictrees.registry.NeoForgeRegistryHandler;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.utility.Optionals;
import com.dtteam.dynamictrees.utility.ResourceLocationUtils;
import dtteam.dtru.tree.TransitionLogFamily;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class BrimwoodFamily
extends TransitionLogFamily {
    public static final TypedRegistry.EntryType<Family> TYPE = TypedRegistry.newType(BrimwoodFamily::new);
    protected Supplier<BranchBlock> magmaBranch;
    protected Block primitiveMagmaLog;
    protected final MutableLazyValue<MagmaBranchStateGenerator> magmaBranchStateGenerator = MutableLazyValue.supplied(MagmaBranchStateGenerator::new);

    public BrimwoodFamily(ResourceLocation name) {
        super(name, false, false);
    }

    public void setupBlocks() {
        super.setupBlocks();
        this.magmaBranch = this.setupBranch(this.createMagmaBranch(this.getBranchName("magma_")), true);
    }

    protected BranchBlock createMagmaBranchBlock(ResourceLocation name) {
        ThickBranchBlock branch = new ThickBranchBlock(this, name, this.getProperties().lightLevel(b -> 4)){

            public Optional<Block> getPrimitiveLog() {
                Family family = this.getFamily();
                if (family instanceof BrimwoodFamily) {
                    BrimwoodFamily magmaLogFamily = (BrimwoodFamily)family;
                    return magmaLogFamily.getPrimitiveMagmaLog();
                }
                return super.getPrimitiveLog();
            }
        };
        if (this.isFireProof()) {
            branch.setFireSpreadSpeed(0).setFlammability(0);
        }
        return branch;
    }

    protected Supplier<BranchBlock> createMagmaBranch(ResourceLocation name) {
        return NeoForgeRegistryHandler.addBlock((ResourceLocation)ResourceLocationUtils.suffix((ResourceLocation)name, (String)this.getBranchNameSuffix()), () -> this.createMagmaBranchBlock(name));
    }

    public Family setPrimitiveMagmaLog(Block primitiveLog) {
        this.primitiveMagmaLog = primitiveLog;
        this.magmaBranch.get().setPrimitiveLogDrops(new ItemStack[]{new ItemStack((ItemLike)primitiveLog)});
        return this;
    }

    public Optional<BranchBlock> getMagmaBranch() {
        return Optionals.ofBlock((Block)this.magmaBranch.get());
    }

    public Optional<Block> getPrimitiveMagmaLog() {
        return Optionals.ofBlock((Block)this.primitiveMagmaLog);
    }

    public void generateStateData(DTBlockStateProvider provider) {
        super.generateStateData((DTDataProvider.BlockState)provider);
        ((MagmaBranchStateGenerator)((Object)this.magmaBranchStateGenerator.get())).generate((DTDataProvider)provider, (Object)this);
    }

    public static class MagmaBranchStateGenerator
    extends BranchStateGenerator {
        @NotNull
        public Generator.Dependencies gatherDependencies(@NotNull Family input) {
            if (input instanceof BrimwoodFamily) {
                BrimwoodFamily castedInput = (BrimwoodFamily)input;
                return new Generator.Dependencies().append(BRANCH, castedInput.getMagmaBranch()).append(PRIMITIVE_LOG, castedInput.getPrimitiveMagmaLog());
            }
            return super.gatherDependencies(input);
        }
    }
}

