/*
 * Decompiled with CFR 0.152.
 */
package dtteam.dtru;

import com.dtteam.dynamictrees.api.registry.Registry;
import com.dtteam.dynamictrees.block.leaves.LeavesProperties;
import com.dtteam.dynamictrees.block.soil.SoilProperties;
import com.dtteam.dynamictrees.data.GatherDataHelper;
import com.dtteam.dynamictrees.registry.NeoForgeRegistryHandler;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.tree.species.Species;
import dtteam.dtru.init.DTRUClient;
import dtteam.dtru.init.DTRUPlusRegistries;
import dtteam.dtru.init.DTRURegistries;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@Mod(value="dtru")
public class DynamicTreesRU {
    public static final String MOD_ID = "dtru";

    public DynamicTreesRU(IEventBus bus, ModContainer modContainer) {
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::gatherData);
        if (DynamicTreesRU.isDynamicTreesPlusLoaded()) {
            bus.register((Object)new DTRUPlusRegistries());
        }
        NeoForgeRegistryHandler.setup((String)MOD_ID, (IEventBus)bus);
        DTRURegistries.setup();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        if (DynamicTreesRU.isDynamicTreesPlusLoaded()) {
            DTRUPlusRegistries.setup();
        }
    }

    private void clientSetup(FMLClientSetupEvent event) {
        DTRUClient.setup();
    }

    private void gatherData(GatherDataEvent event) {
        if (DynamicTreesRU.isDynamicTreesPlusLoaded()) {
            DTRUPlusRegistries.gatherData(event);
        } else {
            GatherDataHelper.gatherAllData((String)MOD_ID, (GatherDataEvent)event, (Registry[])new Registry[]{SoilProperties.REGISTRY, Family.REGISTRY, Species.REGISTRY, LeavesProperties.REGISTRY});
        }
    }

    public static ResourceLocation location(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)name);
    }

    public static boolean isDynamicTreesPlusLoaded() {
        return ModList.get().isLoaded("dynamictreesplus");
    }
}

