/*
 * Decompiled with CFR 0.152.
 */
package dtteam.dtru.block;

import com.dtteam.dynamictrees.api.registry.TypedRegistry;
import com.dtteam.dynamictrees.systems.poissondisc.Vec2i;
import com.dtteam.dynamictreesplus.block.mushroom.CapProperties;
import com.dtteam.dynamictreesplus.block.mushroom.DynamicCapCenterBlock;
import dtteam.dtru.block.BioshroomCapProperties;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class PinkBioshroomCapProperties
extends BioshroomCapProperties {
    public static final TypedRegistry.EntryType<CapProperties> TYPE = TypedRegistry.newType(PinkBioshroomCapProperties::new);

    public PinkBioshroomCapProperties(ResourceLocation registryName) {
        super(registryName);
    }

    protected DynamicCapCenterBlock createDynamicCapCenter(BlockBehaviour.Properties properties) {
        return new DynamicCapCenterBlock(this, this, properties){

            public void clearRing(LevelAccessor level, BlockPos pos, int radius) {
                if (radius == 1) {
                    for (Direction dir : Direction.Plane.HORIZONTAL) {
                        BlockPos ringPos = new BlockPos(pos.getX() + dir.getStepX(), pos.getY(), pos.getZ() + dir.getStepZ());
                        if (!this.getProperties(this.defaultBlockState()).isPartOfCap(level.getBlockState(ringPos))) continue;
                        level.setBlock(ringPos, Blocks.AIR.defaultBlockState(), 2);
                    }
                    return;
                }
                super.clearRing(level, pos, radius - 1);
            }

            public boolean placeRing(LevelAccessor level, BlockPos pos, int radius, int step, boolean yMoved, boolean negFactor) {
                if (radius == 1) {
                    int placed = 0;
                    int notPlaced = 0;
                    CapProperties capProperties = this.getProperties(this.defaultBlockState());
                    for (Direction dir : Direction.Plane.HORIZONTAL) {
                        int x = dir.getStepX();
                        int z = dir.getStepZ();
                        BlockPos ringPos = new BlockPos(pos.getX() + x, pos.getY(), pos.getZ() + z);
                        if (1.canCapReplace((BlockState)level.getBlockState(ringPos))) {
                            level.setBlock(ringPos, this.getStateForAge(capProperties, step, new Vec2i(-x, -z), yMoved, negFactor, capProperties.isPartOfCap(level.getBlockState(ringPos.above()))), 2);
                            ++placed;
                            continue;
                        }
                        ++notPlaced;
                    }
                    return placed >= notPlaced;
                }
                return super.placeRing(level, pos, radius - 1, step, yMoved, negFactor);
            }

            public List<BlockPos> getRing(LevelAccessor level, BlockPos pos, int radius) {
                if (radius == 1) {
                    ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
                    positions.add(pos.north());
                    positions.add(pos.east());
                    positions.add(pos.south());
                    positions.add(pos.west());
                    return positions;
                }
                return super.getRing(level, pos, radius - 1);
            }

            @Nonnull
            private BlockState getStateForAge(CapProperties properties, int age, Vec2i centerDirection, boolean yMoved, boolean negativeFactor, boolean topIsCap) {
                boolean[] dirs = new boolean[]{false, !topIsCap, false, false, false, false};
                if (yMoved || age == 1) {
                    for (Direction dir : Direction.Plane.HORIZONTAL) {
                        float dot = dir.getNormal().getX() * centerDirection.x + dir.getNormal().getZ() * centerDirection.z;
                        if (!(dot >= 0.0f)) continue;
                        dirs[negativeFactor ? dir.ordinal() : dir.getOpposite().ordinal()] = true;
                    }
                }
                return properties.getDynamicCapState(age, dirs);
            }
        };
    }
}

