/*
 * Decompiled with CFR 0.152.
 */
package dtteam.dtru.block;

import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.branch.ThickBranchBlock;
import com.dtteam.dynamictrees.tree.TreeHelper;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class TransitionLogBranchBlock
extends ThickBranchBlock {
    public static final BooleanProperty TRANSITION = BooleanProperty.create((String)"transition");
    boolean transitionOnStripped;
    boolean transitionOnBase;

    public TransitionLogBranchBlock(ResourceLocation name, BlockBehaviour.Properties properties, boolean stripped, boolean base) {
        super(name, properties);
        this.transitionOnStripped = stripped;
        this.transitionOnBase = base;
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{TRANSITION});
    }

    public int setRadius(LevelAccessor level, BlockPos pos, int radius, @Nullable Direction originDir, int flags) {
        boolean doTransition = false;
        BlockState branch = level.getBlockState(pos);
        if (branch.hasProperty((Property)TRANSITION) && ((Boolean)branch.getValue((Property)TRANSITION)).booleanValue()) {
            doTransition = true;
        }
        int rad = super.setRadius(level, pos, radius, originDir, flags);
        if (this.isStrippedBranch()) {
            return rad;
        }
        if (!doTransition && this.transitionOnBase && TreeHelper.isRooty((BlockState)level.getBlockState(pos.below()))) {
            doTransition = true;
        }
        if (doTransition) {
            level.setBlock(pos, (BlockState)level.getBlockState(pos).setValue((Property)TRANSITION, (Comparable)Boolean.valueOf(true)), flags);
        }
        return rad;
    }

    public void stripBranch(BlockState state, LevelAccessor level, BlockPos pos, int radius) {
        BlockState upState;
        BranchBlock upBranch;
        boolean isTransition = state.hasProperty((Property)TRANSITION) && (Boolean)state.getValue((Property)TRANSITION) != false;
        int reducedRadius = this.getFamily().reduceRadiusWhenStripping() && (!isTransition || !this.transitionOnStripped) ? 1 : 0;
        this.getFamily().getStrippedBranch().ifPresent(strippedBranch -> strippedBranch.setRadius(level, pos, Math.max(1, radius - reducedRadius), null, 3));
        if (this.transitionOnStripped && (upBranch = TreeHelper.getBranch((BlockState)(upState = level.getBlockState(pos.above())))) != null && !upBranch.isStrippedBranch()) {
            int upRad = upBranch.getRadius(upState);
            int thisRad = TreeHelper.getRadius((BlockGetter)level, (BlockPos)pos);
            BlockState newState = (BlockState)upBranch.getStateForRadius(Math.min(upRad, thisRad)).setValue((Property)TRANSITION, (Comparable)Boolean.valueOf(true));
            level.setBlock(pos.above(), newState, 3);
        }
    }

    public BlockState getStateForRadius(int radius) {
        return (BlockState)super.getStateForRadius(radius).setValue((Property)TRANSITION, (Comparable)Boolean.valueOf(false));
    }
}

