/*
 * Decompiled with CFR 0.152.
 */
package dtteam.dtru.genfeature;

import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.block.soil.SoilHelper;
import com.dtteam.dynamictrees.systems.genfeature.GenFeature;
import com.dtteam.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.dtteam.dynamictrees.systems.genfeature.context.FullGenerationContext;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.worldgen.DynamicTreeGenerationContext;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;

public class SoilWhitelistGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Species> REPLACEMENT_SPECIES = ConfigurationProperty.property((String)"replacement_species", Species.class);
    public static final ConfigurationProperty<Float> REPLACEMENT_CHANCE = ConfigurationProperty.floatProperty((String)"replacement_chance");
    public static final ConfigurationProperty<Boolean> BLACKLIST = ConfigurationProperty.bool((String)"use_blacklist");
    public static final ConfigurationProperty<String> ALLOWED_SOIL = ConfigurationProperty.string((String)"allowed_soil");

    public SoilWhitelistGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{ALLOWED_SOIL, BLACKLIST, REPLACEMENT_CHANCE, REPLACEMENT_SPECIES});
    }

    protected GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(BLACKLIST, (Object)false)).with(ALLOWED_SOIL, (Object)"")).with(REPLACEMENT_CHANCE, (Object)Float.valueOf(0.4f))).with(REPLACEMENT_SPECIES, (Object)Species.NULL_SPECIES);
    }

    protected boolean generate(GenFeatureConfiguration configuration, FullGenerationContext context) {
        Species species;
        if ((Boolean)configuration.get(BLACKLIST) ^ SoilHelper.isSoilAcceptable((BlockState)context.level().getBlockState(context.pos()), (int)SoilHelper.getSoilFlags((String[])new String[]{(String)configuration.get(ALLOWED_SOIL)}))) {
            return super.generate(configuration, context);
        }
        if (context.random().nextFloat() < ((Float)configuration.get(REPLACEMENT_CHANCE)).floatValue() && (species = (Species)configuration.get(REPLACEMENT_SPECIES)).isValid()) {
            species.generate(new DynamicTreeGenerationContext(context.levelContext(), species, context.pos(), context.pos().mutable(), context.biome(), Direction.Plane.HORIZONTAL.getRandomDirection(context.random()), context.radius(), context.isWorldGen()));
        }
        return true;
    }
}

