/*
 * Decompiled with CFR 0.152.
 */
package dtteam.dtru.genfeature;

import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.systems.genfeature.GenFeature;
import com.dtteam.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictreesplus.block.mushroom.DynamicCapCenterBlock;
import com.dtteam.dynamictreesplus.tree.HugeMushroomSpecies;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class TrunkBioshroomGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Block> BLOCK = ConfigurationProperty.block((String)"block");
    public static final ConfigurationProperty<Integer> LOWEST_BLOCK_POS = ConfigurationProperty.integer((String)"lowest_block_pos");

    public TrunkBioshroomGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{BLOCK, LOWEST_BLOCK_POS, PLACE_CHANCE});
    }

    public boolean shouldApply(Species species, GenFeatureConfiguration configuration) {
        if (configuration.get(BLOCK) == Blocks.AIR) {
            return false;
        }
        if (!(species instanceof HugeMushroomSpecies)) {
            return false;
        }
        return super.shouldApply(species, configuration);
    }

    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(BLOCK, (Object)Blocks.AIR)).with(LOWEST_BLOCK_POS, (Object)3)).with(PLACE_CHANCE, (Object)Float.valueOf(0.05f));
    }

    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        LevelAccessor level = context.level();
        BlockPos.MutableBlockPos testPos = context.pos().above(((Integer)configuration.get(LOWEST_BLOCK_POS)).intValue()).mutable();
        List<BlockPos> validPositions = this.FindValidPositions(level, testPos);
        if (!(context.level().getBlockState((BlockPos)testPos).getBlock() instanceof DynamicCapCenterBlock)) {
            return false;
        }
        boolean placed = false;
        for (BlockPos pos : validPositions) {
            if (!(level.getRandom().nextFloat() <= ((Float)configuration.get(PLACE_CHANCE)).floatValue()) || !this.IsFreeAboveAndBelow(level, pos)) continue;
            level.setBlock(pos, ((Block)configuration.get(BLOCK)).defaultBlockState(), 2);
            placed = true;
        }
        return placed;
    }

    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        if (context.fertility() == 0) {
            return false;
        }
        LevelAccessor level = context.level();
        BlockPos.MutableBlockPos testPos = context.pos().above(((Integer)configuration.get(LOWEST_BLOCK_POS)).intValue()).mutable();
        List<BlockPos> validPositions = this.FindValidPositions(level, testPos);
        boolean placed = false;
        if (level.getRandom().nextFloat() <= ((Float)configuration.get(PLACE_CHANCE)).floatValue() && !validPositions.isEmpty()) {
            BlockPos pos = validPositions.get(context.random().nextInt(validPositions.size()));
            if (this.IsFreeAboveAndBelow(level, pos)) {
                level.setBlock(pos, ((Block)configuration.get(BLOCK)).defaultBlockState(), 0);
            }
            placed = true;
        }
        return placed;
    }

    protected List<BlockPos> FindValidPositions(LevelAccessor level, BlockPos.MutableBlockPos testPos) {
        ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
        while (TreeHelper.isBranch((BlockState)level.getBlockState((BlockPos)testPos))) {
            testPos.move(Direction.UP);
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos side = testPos.offset(dir.getNormal());
                validPositions.add(side);
            }
        }
        return validPositions;
    }

    private boolean IsFreeAboveAndBelow(LevelAccessor level, BlockPos pos) {
        return level.getBlockState(pos).canBeReplaced() && level.getBlockState(pos.above()).canBeReplaced() && level.getBlockState(pos.below()).canBeReplaced();
    }
}

