/*
 * Decompiled with CFR 0.152.
 */
package dtteam.dtru.growthlogic;

import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.systems.GrowSignal;
import com.dtteam.dynamictrees.systems.growthlogic.GrowthLogicKitConfiguration;
import com.dtteam.dynamictrees.systems.growthlogic.context.DirectionManipulationContext;
import com.dtteam.dynamictrees.systems.growthlogic.context.DirectionSelectionContext;
import com.dtteam.dynamictrees.systems.growthlogic.context.PositionalSpeciesContext;
import com.dtteam.dynamictrees.utility.CoordUtils;
import dtteam.dtru.growthlogic.VariateHeightLogic;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;

public class CypressLogic
extends VariateHeightLogic {
    public static final ConfigurationProperty<Float> CANOPY_ENERGY = ConfigurationProperty.floatProperty((String)"canopy_energy");
    public static final ConfigurationProperty<Float> BOTTOM_BRANCH_SIDE_ENERGY = ConfigurationProperty.floatProperty((String)"bottom_branch_side_energy");

    public CypressLogic(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(CANOPY_ENERGY, (Object)Float.valueOf(10.5f))).with(BOTTOM_BRANCH_SIDE_ENERGY, (Object)Float.valueOf(4.5f))).with(HEIGHT_VARIATION, (Object)10);
    }

    @Override
    protected void registerProperties() {
        super.registerProperties();
        this.register(new ConfigurationProperty[]{CANOPY_ENERGY, BOTTOM_BRANCH_SIDE_ENERGY});
    }

    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        int[] probMap = context.probMap();
        GrowSignal signal = context.signal();
        Direction originDir = context.signal().dir.getOpposite();
        int treeHash = CoordUtils.coordHashCode((BlockPos)signal.rootPos, (int)2);
        probMap[0] = 0;
        probMap[1] = context.species().getUpProbability();
        probMap[5] = 2;
        probMap[4] = 2;
        probMap[3] = 2;
        probMap[2] = 2;
        if (signal.energy > ((Float)configuration.get(CANOPY_ENERGY)).floatValue()) {
            probMap[5] = 0;
            probMap[4] = 0;
            probMap[3] = 0;
            probMap[2] = 0;
            if (signal.delta.getY() <= configuration.getLowestBranchHeight((PositionalSpeciesContext)context) + 1) {
                probMap[1] = probMap[1] + 3;
                int sideHash = treeHash % 16;
                probMap[2] = sideHash % 2 < 1 ? 1 : 0;
                probMap[3] = sideHash % 4 < 2 ? 1 : 0;
                probMap[4] = sideHash % 8 < 4 ? 1 : 0;
                probMap[5] = sideHash < 8 ? 1 : 0;
            }
        } else if (signal.isInTrunk()) {
            probMap[1] = probMap[1] + 1;
        } else if (context.signal().numTurns == 1) {
            Vec3i vec3i = new Vec3i(0, context.signal().delta.getY(), 0);
            if (context.signal().delta.distSqr(vec3i) <= 1.0) {
                probMap[1] = 0;
            }
        }
        probMap[originDir.ordinal()] = 0;
        return probMap;
    }

    public Direction selectNewDirection(GrowthLogicKitConfiguration configuration, DirectionSelectionContext context) {
        Direction newDir = super.selectNewDirection(configuration, context);
        if (context.signal().isInTrunk() && newDir != Direction.UP && context.signal().delta.getY() <= configuration.getLowestBranchHeight((PositionalSpeciesContext)context) + 1) {
            context.signal().energy = ((Float)configuration.get(BOTTOM_BRANCH_SIDE_ENERGY)).floatValue();
        }
        return newDir;
    }

    @Override
    public int getLowestBranchHeight(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return context.species().getLowestBranchHeight();
    }
}

