/*
 * Decompiled with CFR 0.152.
 */
package dtteam.dtru.init;

import com.dtteam.dynamictrees.api.cell.CellKit;
import com.dtteam.dynamictrees.api.registry.Registry;
import com.dtteam.dynamictrees.api.registry.RegistryEntry;
import com.dtteam.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.dtteam.dynamictrees.api.worldgen.FeatureCanceller;
import com.dtteam.dynamictrees.block.CommonVoxelShapes;
import com.dtteam.dynamictrees.block.leaves.LeavesProperties;
import com.dtteam.dynamictrees.event.RegistryEvent;
import com.dtteam.dynamictrees.event.TypeRegistryEvent;
import com.dtteam.dynamictrees.systems.genfeature.GenFeature;
import com.dtteam.dynamictrees.systems.growthlogic.GrowthLogicKit;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.worldgen.featurecancellation.TreeFeatureCanceller;
import dtteam.dtru.DynamicTreesRU;
import dtteam.dtru.cell.DTRUCellKits;
import dtteam.dtru.genfeature.DTRUGenFeatures;
import dtteam.dtru.growthlogic.DTRUGrowthLogicKits;
import dtteam.dtru.init.DTRUPlusRegistries;
import dtteam.dtru.tree.BambooFamily;
import dtteam.dtru.tree.BrimwoodFamily;
import dtteam.dtru.tree.EucalyptusFamily;
import dtteam.dtru.tree.GenUnderwaterSpecies;
import dtteam.dtru.tree.TransitionLogFamily;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.regions_unexplored.world.features.treedecorators.BlackwoodBioshroom;
import net.regions_unexplored.world.level.feature.configuration.GiantBioshroomConfiguration;
import net.regions_unexplored.world.level.feature.configuration.RuTreeConfiguration;
import net.regions_unexplored.world.level.feature.tree.CobaltShrubFeature;
import net.regions_unexplored.world.level.feature.tree.LargeJoshuaTreeFeature;
import net.regions_unexplored.world.level.feature.tree.MediumJoshuaTreeFeature;
import net.regions_unexplored.world.level.feature.tree.SmallSocotraTreeFeature;
import net.regions_unexplored.world.level.feature.tree.YellowBioshroomShrubFeature;
import net.regions_unexplored.world.level.feature.tree.nether.BrimWillowFeature;
import net.regions_unexplored.world.level.feature.tree.nether.TallBrimWillowFeature;

@EventBusSubscriber(modid="dtru")
public class DTRURegistries {
    public static final VoxelShape MUSHROOM_CAP_CONE_BASE = Shapes.box((double)0.3125, (double)0.1875, (double)0.3125, (double)0.6875, (double)0.375, (double)0.6875);
    public static final VoxelShape MUSHROOM_CAP_TIP_1 = Shapes.box((double)0.375, (double)0.375, (double)0.375, (double)0.625, (double)0.5625, (double)0.625);
    public static final VoxelShape MUSHROOM_CAP_SHORT_ROUND = Shapes.box((double)0.28125, (double)0.1875, (double)0.28125, (double)0.71875, (double)0.5, (double)0.71875);
    public static final VoxelShape SHORT_ROUND_MUSHROOM = Shapes.or((VoxelShape)CommonVoxelShapes.SAPLING_TRUNK, (VoxelShape)MUSHROOM_CAP_SHORT_ROUND);
    public static final VoxelShape CONE_MUSHROOM = Shapes.or((VoxelShape)CommonVoxelShapes.SAPLING_TRUNK, (VoxelShape)Shapes.or((VoxelShape)MUSHROOM_CAP_CONE_BASE, (VoxelShape)MUSHROOM_CAP_TIP_1));
    public static final FeatureCanceller RU_TREE_CANCELLER = new TreeFeatureCanceller(DynamicTreesRU.location("tree"), RuTreeConfiguration.class);
    public static final FeatureCanceller RU_TREE2_CANCELLER = new TreeFeatureCanceller<NoneFeatureConfiguration>(DynamicTreesRU.location("tree_2"), NoneFeatureConfiguration.class){

        public boolean shouldCancel(ConfiguredFeature<?, ?> configuredFeature, BiomePropertySelectors.NormalFeatureCancellation featureCancellations) {
            Feature featureConfig = configuredFeature.feature();
            return featureConfig instanceof LargeJoshuaTreeFeature || featureConfig instanceof MediumJoshuaTreeFeature || featureConfig instanceof SmallSocotraTreeFeature || featureConfig instanceof CobaltShrubFeature || featureConfig instanceof BrimWillowFeature || featureConfig instanceof TallBrimWillowFeature;
        }
    };
    public static final FeatureCanceller RU_MUSHROOM_CANCELLER = new TreeFeatureCanceller(DynamicTreesRU.location("mushroom"), GiantBioshroomConfiguration.class);
    public static final FeatureCanceller RU_MUSHROOM2_CANCELLER = new TreeFeatureCanceller<NoneFeatureConfiguration>(DynamicTreesRU.location("mushroom_2"), NoneFeatureConfiguration.class){

        public boolean shouldCancel(ConfiguredFeature<?, ?> configuredFeature, BiomePropertySelectors.NormalFeatureCancellation featureCancellations) {
            Feature featureConfig = configuredFeature.feature();
            return featureConfig instanceof YellowBioshroomShrubFeature || featureConfig instanceof CobaltShrubFeature || configuredFeature.config() instanceof HugeMushroomFeatureConfiguration;
        }
    };
    public static final FeatureCanceller TREE_NO_SHROOMS_CANCELLER = new TreeFeatureCanceller<NoneFeatureConfiguration>(DynamicTreesRU.location("tree_no_shrooms"), NoneFeatureConfiguration.class){

        private boolean isConfigClass(FeatureConfiguration config) {
            return config instanceof TreeConfiguration || config instanceof RuTreeConfiguration;
        }

        public boolean shouldCancel(ConfiguredFeature<?, ?> configuredFeature, BiomePropertySelectors.NormalFeatureCancellation featureCancellations) {
            FeatureConfiguration featureConfig = configuredFeature.config();
            if (this.isConfigClass(featureConfig)) {
                if (featureConfig instanceof TreeConfiguration) {
                    TreeConfiguration treeConfiguration = (TreeConfiguration)featureConfig;
                    if (!treeConfiguration.decorators.isEmpty() && treeConfiguration.decorators.getFirst() instanceof BlackwoodBioshroom) {
                        return false;
                    }
                }
                String nameSpace = "";
                Optional firstFeature = configuredFeature.getFeatures().findFirst();
                if (firstFeature.isEmpty()) {
                    return false;
                }
                ConfiguredFeature nextConfiguredFeature = (ConfiguredFeature)firstFeature.get();
                FeatureConfiguration nextFeatureConfig = nextConfiguredFeature.config();
                ResourceLocation featureRegistryName = BuiltInRegistries.FEATURE.getKey((Object)nextConfiguredFeature.feature());
                if (featureRegistryName != null) {
                    nameSpace = featureRegistryName.getNamespace();
                }
                return this.isConfigClass(nextFeatureConfig) && !nameSpace.isEmpty() && featureCancellations.shouldCancelNamespace(nameSpace);
            }
            return false;
        }
    };

    public static void setup() {
        CommonVoxelShapes.SHAPES.put(DynamicTreesRU.location("blue_bioshroom").toString(), SHORT_ROUND_MUSHROOM);
        CommonVoxelShapes.SHAPES.put(DynamicTreesRU.location("pink_bioshroom").toString(), CONE_MUSHROOM);
    }

    @SubscribeEvent
    public static void onGenFeatureRegistry(RegistryEvent<GenFeature> event) {
        if (!event.isEntryOfType(GenFeature.class)) {
            return;
        }
        DTRUGenFeatures.register((Registry<GenFeature>)event.getRegistry());
    }

    @SubscribeEvent
    public static void onGrowthLogicKitRegistry(RegistryEvent<GrowthLogicKit> event) {
        if (!event.isEntryOfType(GrowthLogicKit.class)) {
            return;
        }
        DTRUGrowthLogicKits.register((Registry<GrowthLogicKit>)event.getRegistry());
    }

    @SubscribeEvent
    public static void onCellKitRegistry(RegistryEvent<CellKit> event) {
        if (!event.isEntryOfType(CellKit.class)) {
            return;
        }
        DTRUCellKits.register((Registry<CellKit>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerLeavesPropertiesTypes(TypeRegistryEvent<LeavesProperties> event) {
        if (!event.isEntryOfType(LeavesProperties.class)) {
            return;
        }
    }

    @SubscribeEvent
    public static void registerSpeciesTypes(TypeRegistryEvent<Species> event) {
        if (!event.isEntryOfType(Species.class)) {
            return;
        }
        event.registerType(DynamicTreesRU.location("cypress"), GenUnderwaterSpecies.TYPE);
        if (DynamicTreesRU.isDynamicTreesPlusLoaded()) {
            DTRUPlusRegistries.registerSpeciesTypes(event);
        }
    }

    @SubscribeEvent
    public static void registerFamilyTypes(TypeRegistryEvent<Family> event) {
        if (!event.isEntryOfType(Family.class)) {
            return;
        }
        event.registerType(DynamicTreesRU.location("bamboo"), BambooFamily.TYPE);
        event.registerType(DynamicTreesRU.location("eucalyptus"), EucalyptusFamily.TYPE);
        event.registerType(DynamicTreesRU.location("stripped_transition_log"), TransitionLogFamily.TYPE_STRIPPED);
        event.registerType(DynamicTreesRU.location("base_transition_log"), TransitionLogFamily.TYPE_BASE);
        event.registerType(DynamicTreesRU.location("brimwood"), BrimwoodFamily.TYPE);
    }

    @SubscribeEvent
    public static void onFeatureCancellerRegistry(RegistryEvent<FeatureCanceller> event) {
        if (!event.isEntryOfType(FeatureCanceller.class)) {
            return;
        }
        event.getRegistry().registerAll((RegistryEntry[])new FeatureCanceller[]{RU_TREE_CANCELLER, RU_TREE2_CANCELLER, RU_MUSHROOM_CANCELLER, RU_MUSHROOM2_CANCELLER, TREE_NO_SHROOMS_CANCELLER});
    }
}

