/*
 * Decompiled with CFR 0.152.
 */
package dtteam.dtru.model;

import com.dtteam.dynamictrees.model.geometry.BranchBlockModelGeometry;
import com.dtteam.dynamictrees.tree.family.Family;
import dtteam.dtru.model.EucalyptusBranchBlockBakedModel;
import dtteam.dtru.model.ThickEucalyptusBranchBlockBakedModel;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;

@OnlyIn(value=Dist.CLIENT)
public class EucalyptusBranchBlockModelGeometry
extends BranchBlockModelGeometry {
    protected final ResourceLocation overlayTextureLocation;

    public EucalyptusBranchBlockModelGeometry(ResourceLocation barkTextureLocation, ResourceLocation ringsTextureLocation, ResourceLocation overlayTextureLocation, @Nullable ResourceLocation familyName) {
        super(barkTextureLocation, ringsTextureLocation, familyName, false);
        this.overlayTextureLocation = overlayTextureLocation;
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker modelBaker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides itemOverrides) {
        boolean useThickModel = this.useThickModel(this.setFamily(ResourceLocation.tryParse((String)context.getModelName())));
        if (!useThickModel) {
            return new EucalyptusBranchBlockBakedModel(context, ResourceLocation.tryParse((String)context.getModelName()), this.barkTextureLocation, this.ringsTextureLocation, this.overlayTextureLocation, spriteGetter);
        }
        if (this.thickRingsTextureLocation == null) {
            this.thickRingsTextureLocation = this.ringsTextureLocation.withSuffix("_thick");
        }
        return new ThickEucalyptusBranchBlockBakedModel(context, ResourceLocation.tryParse((String)context.getModelName()), this.barkTextureLocation, this.ringsTextureLocation, this.overlayTextureLocation, this.thickRingsTextureLocation, spriteGetter);
    }

    private ResourceLocation setFamilyName(ResourceLocation modelLocation) {
        if (this.familyName == null) {
            this.familyName = ResourceLocation.tryBuild((String)modelLocation.getNamespace(), (String)modelLocation.getPath().replace("block/", "").replace("_branch", "").replace("stripped_", ""));
        }
        return this.familyName;
    }

    private Family setFamily(ResourceLocation modelResLoc) {
        if (this.family == null) {
            this.family = (Family)Family.REGISTRY.get(this.setFamilyName(modelResLoc));
        }
        return this.family;
    }
}

