/*
 * Decompiled with CFR 0.152.
 */
package dtteam.dtru.systems;

import com.dtteam.dynamictrees.api.treedata.TreePart;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.utility.CoordUtils;
import com.dtteam.dynamictreesplus.block.mushroom.DynamicCapCenterBlock;
import com.dtteam.dynamictreesplus.systems.nodemapper.MushroomInflatorNode;
import com.dtteam.dynamictreesplus.tree.HugeMushroomSpecies;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import oshi.util.tuples.Pair;

public class SmallBioshroomInflatorNode
extends MushroomInflatorNode {
    HugeMushroomSpecies species;
    private static final int minRadiusHeightDivider = 3;
    private float radius;
    private BlockPos last;
    private final BlockPos highestTrunkBlock;
    private final List<Pair<BlockPos, Integer>> capAges;
    private final int generationRadius;
    private int lastCapBranchRadius;
    private final BlockPos rootPos;

    public SmallBioshroomInflatorNode(HugeMushroomSpecies species, List<Pair<BlockPos, Integer>> capAges, int genRadius, BlockPos root) {
        super(species, capAges, genRadius, root);
        this.species = species;
        this.last = BlockPos.ZERO;
        this.highestTrunkBlock = null;
        this.capAges = capAges;
        this.generationRadius = genRadius;
        this.rootPos = root;
    }

    public boolean returnRun(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir) {
        BranchBlock branch;
        BlockPos dist = pos.subtract((Vec3i)this.last);
        if (dist.getX() * dist.getX() + dist.getY() * dist.getY() + dist.getZ() * dist.getZ() != 1 && DynamicCapCenterBlock.canCapReplace((BlockState)level.getBlockState(pos.above()))) {
            int height = pos.subtract((Vec3i)this.rootPos).getY();
            int maxAge = Math.min(Math.min(Math.min(this.species.getCapProperties().getMaxAge(this.species), 8), height), this.generationRadius);
            int minAge = Math.max(2, Math.max(0, height / 3));
            int capAge = minAge + CoordUtils.coordHashCode((BlockPos)new BlockPos(pos.getX(), 0, pos.getZ()), (int)3) % (Math.abs(maxAge - minAge) + 1);
            this.lastCapBranchRadius = Math.min(this.species.getFamily().getPrimaryThickness() + capAge, this.species.getMaxBranchRadius());
            this.radius = this.lastCapBranchRadius;
            this.capAges.add((Pair<BlockPos, Integer>)new Pair((Object)pos.above(), (Object)capAge));
        }
        if ((branch = TreeHelper.getBranch((BlockState)state)) != null) {
            float areaAccum = this.radius * this.radius;
            boolean isTwig = true;
            for (Direction dir : Direction.values()) {
                if (dir.equals((Object)fromDir)) continue;
                BlockPos dPos = pos.relative(dir);
                if (dPos.equals((Object)this.last)) {
                    isTwig = false;
                    continue;
                }
                BlockState deltaBlockState = level.getBlockState(dPos);
                TreePart treepart = TreeHelper.getTreePart((BlockState)deltaBlockState);
                if (!branch.isSameTree(treepart)) continue;
                int branchRadius = treepart.getRadius(deltaBlockState);
                areaAccum += (float)(branchRadius * branchRadius);
            }
            if (isTwig) {
                branch.setRadius(level, pos, (int)this.radius, null);
            } else {
                float secondaryThickness;
                this.radius = (float)Math.sqrt(areaAccum) + this.species.getTapering() * this.species.getWorldGenTaperingFactor();
                int maxRadius = this.species.getMaxBranchRadius();
                if (this.radius > (float)maxRadius) {
                    this.radius = maxRadius;
                }
                if (this.highestTrunkBlock != null) {
                    boolean isInTrunk;
                    int blockRadius = 8;
                    boolean bl = isInTrunk = pos.getX() == this.highestTrunkBlock.getX() && pos.getY() <= this.highestTrunkBlock.getY() && pos.getZ() == this.highestTrunkBlock.getZ();
                    if (this.radius > (float)blockRadius && !isInTrunk) {
                        this.radius = blockRadius;
                    }
                }
                if (this.radius < (secondaryThickness = (float)Math.min(this.lastCapBranchRadius + 1, this.species.getMaxBranchRadius()))) {
                    this.radius = secondaryThickness;
                }
                branch.setRadius(level, pos, (int)Math.floor(this.radius), null);
            }
            this.last = pos;
        }
        return false;
    }
}

