/*
 * Decompiled with CFR 0.152.
 */
package dtteam.dtru;

import com.ferreusveritas.dynamictrees.api.GatherDataHelper;
import com.ferreusveritas.dynamictrees.api.registry.Registry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryHandler;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.block.rooty.SoilProperties;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import dtteam.dtru.init.DTRUClient;
import dtteam.dtru.init.DTRUPlusRegistries;
import dtteam.dtru.init.DTRURegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="dtru")
public class DynamicTreesRU {
    public static final String MOD_ID = "dtru";

    public DynamicTreesRU() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::gatherData);
        if (DynamicTreesRU.isDynamicTreesPlusLoaded()) {
            modEventBus.register((Object)new DTRUPlusRegistries());
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        RegistryHandler.setup((String)MOD_ID);
        DTRURegistries.setup();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        if (DynamicTreesRU.isDynamicTreesPlusLoaded()) {
            DTRUPlusRegistries.setup();
        }
    }

    private void clientSetup(FMLClientSetupEvent event) {
        DTRUClient.setup();
    }

    private void gatherData(GatherDataEvent event) {
        if (DynamicTreesRU.isDynamicTreesPlusLoaded()) {
            DTRUPlusRegistries.gatherData(event);
        } else {
            GatherDataHelper.gatherAllData((String)MOD_ID, (GatherDataEvent)event, (Registry[])new Registry[]{SoilProperties.REGISTRY, Family.REGISTRY, Species.REGISTRY, LeavesProperties.REGISTRY});
        }
    }

    public static ResourceLocation location(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static boolean isDynamicTreesPlusLoaded() {
        return ModList.get().isLoaded("dynamictreesplus");
    }
}

