/*
 * Decompiled with CFR 0.152.
 */
package dtteam.dtru.block;

import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.systems.poissondisc.Vec2i;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictreesplus.block.mushroom.CapProperties;
import com.ferreusveritas.dynamictreesplus.block.mushroom.DynamicCapCenterBlock;
import com.ferreusveritas.dynamictreesplus.systems.mushroomlogic.MushroomCapDisc;
import dtteam.dtru.block.BioshroomCapProperties;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class GreenBioshroomCapProperties
extends BioshroomCapProperties {
    public static final TypedRegistry.EntryType<CapProperties> TYPE = TypedRegistry.newType(GreenBioshroomCapProperties::new);

    public GreenBioshroomCapProperties(ResourceLocation registryName) {
        super(registryName);
    }

    protected DynamicCapCenterBlock createDynamicCapCenter(BlockBehaviour.Properties properties) {
        return new DynamicCapCenterBlock(this, properties){

            public List<BlockPos> getRing(LevelAccessor level, BlockPos pos, int radius) {
                return super.getRing(level, pos, Math.min(radius, 3));
            }

            public void clearRing(LevelAccessor level, BlockPos pos, int radius) {
                super.clearRing(level, pos, Math.min(radius, 3));
            }

            public boolean placeRing(LevelAccessor level, BlockPos pos, int radius, int step, boolean yMoved, boolean negFactor) {
                List ring = MushroomCapDisc.getPrecomputedRing((int)Math.min(radius, 3));
                int placed = 0;
                int notPlaced = 0;
                for (Vec2i vec : ring) {
                    BlockPos ringPos = new BlockPos(pos.m_123341_() + vec.x, pos.m_123342_(), pos.m_123343_() + vec.z);
                    if (1.canCapReplace((BlockState)level.m_8055_(ringPos))) {
                        if (step <= 3 || this.ShouldPlaceBlock(level, ringPos)) {
                            level.m_7731_(ringPos, this.getStateForAge(this.f_60439_, step, new Vec2i(-vec.x, -vec.z), yMoved, negFactor, this.f_60439_.isPartOfCap(level.m_8055_(ringPos.m_7494_()))), 2);
                        }
                        ++placed;
                        continue;
                    }
                    ++notPlaced;
                }
                return placed >= notPlaced;
            }

            private boolean ShouldPlaceBlock(LevelAccessor level, BlockPos pos) {
                BlockState upState = level.m_8055_(pos.m_7494_());
                Optional capBlock = this.f_60439_.getDynamicCapBlock();
                if (capBlock.isEmpty() || !upState.m_60713_((Block)capBlock.get())) {
                    return false;
                }
                return CoordUtils.coordHashCode((BlockPos)pos, (int)2) % 3 != 0;
            }

            @Nonnull
            private BlockState getStateForAge(CapProperties properties, int age, Vec2i centerDirection, boolean yMoved, boolean negativeFactor, boolean topIsCap) {
                boolean[] dirs = new boolean[]{false, !topIsCap, true, true, true, true};
                if (yMoved || age == 1) {
                    for (Direction dir : Direction.Plane.HORIZONTAL) {
                        float dot = dir.m_122436_().m_123341_() * centerDirection.x + dir.m_122436_().m_123343_() * centerDirection.z;
                        if (!(dot >= 0.0f)) continue;
                        dirs[negativeFactor ? dir.m_122424_().ordinal() : dir.ordinal()] = false;
                    }
                }
                return properties.getDynamicCapState(age, dirs);
            }
        };
    }
}

