/*
 * Decompiled with CFR 0.152.
 */
package dtteam.dtru.block;

import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.systems.poissondisc.Vec2i;
import com.ferreusveritas.dynamictreesplus.block.mushroom.CapProperties;
import com.ferreusveritas.dynamictreesplus.block.mushroom.DynamicCapCenterBlock;
import dtteam.dtru.block.BioshroomCapProperties;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class PinkBioshroomCapProperties
extends BioshroomCapProperties {
    public static final TypedRegistry.EntryType<CapProperties> TYPE = TypedRegistry.newType(PinkBioshroomCapProperties::new);

    public PinkBioshroomCapProperties(ResourceLocation registryName) {
        super(registryName);
    }

    protected DynamicCapCenterBlock createDynamicCapCenter(BlockBehaviour.Properties properties) {
        return new DynamicCapCenterBlock(this, properties){

            public void clearRing(LevelAccessor level, BlockPos pos, int radius) {
                if (radius == 1) {
                    for (Direction dir : Direction.Plane.HORIZONTAL) {
                        BlockPos ringPos = new BlockPos(pos.m_123341_() + dir.m_122429_(), pos.m_123342_(), pos.m_123343_() + dir.m_122431_());
                        if (!this.getProperties(this.m_49966_()).isPartOfCap(level.m_8055_(ringPos))) continue;
                        level.m_7731_(ringPos, Blocks.f_50016_.m_49966_(), 2);
                    }
                    return;
                }
                super.clearRing(level, pos, radius - 1);
            }

            public boolean placeRing(LevelAccessor level, BlockPos pos, int radius, int step, boolean yMoved, boolean negFactor) {
                if (radius == 1) {
                    int placed = 0;
                    int notPlaced = 0;
                    CapProperties capProperties = this.getProperties(this.m_49966_());
                    for (Direction dir : Direction.Plane.HORIZONTAL) {
                        int x = dir.m_122429_();
                        int z = dir.m_122431_();
                        BlockPos ringPos = new BlockPos(pos.m_123341_() + x, pos.m_123342_(), pos.m_123343_() + z);
                        if (1.canCapReplace((BlockState)level.m_8055_(ringPos))) {
                            level.m_7731_(ringPos, this.getStateForAge(capProperties, step, new Vec2i(-x, -z), yMoved, negFactor, capProperties.isPartOfCap(level.m_8055_(ringPos.m_7494_()))), 2);
                            ++placed;
                            continue;
                        }
                        ++notPlaced;
                    }
                    return placed >= notPlaced;
                }
                return super.placeRing(level, pos, radius - 1, step, yMoved, negFactor);
            }

            public List<BlockPos> getRing(LevelAccessor level, BlockPos pos, int radius) {
                if (radius == 1) {
                    ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
                    positions.add(pos.m_122012_());
                    positions.add(pos.m_122029_());
                    positions.add(pos.m_122019_());
                    positions.add(pos.m_122024_());
                    return positions;
                }
                return super.getRing(level, pos, radius - 1);
            }

            @Nonnull
            private BlockState getStateForAge(CapProperties properties, int age, Vec2i centerDirection, boolean yMoved, boolean negativeFactor, boolean topIsCap) {
                boolean[] dirs = new boolean[]{false, !topIsCap, false, false, false, false};
                if (yMoved || age == 1) {
                    for (Direction dir : Direction.Plane.HORIZONTAL) {
                        float dot = dir.m_122436_().m_123341_() * centerDirection.x + dir.m_122436_().m_123343_() * centerDirection.z;
                        if (!(dot >= 0.0f)) continue;
                        dirs[negativeFactor ? dir.ordinal() : dir.m_122424_().ordinal()] = true;
                    }
                }
                return properties.getDynamicCapState(age, dirs);
            }
        };
    }
}

