/*
 * Decompiled with CFR 0.152.
 */
package dtteam.dtru.block;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.branch.ThickBranchBlock;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class TransitionLogBranchBlock
extends ThickBranchBlock {
    public static final BooleanProperty TRANSITION = BooleanProperty.m_61465_((String)"transition");
    boolean transitionOnStripped;
    boolean transitionOnBase;

    public TransitionLogBranchBlock(ResourceLocation name, BlockBehaviour.Properties properties, boolean stripped, boolean base) {
        super(name, properties);
        this.transitionOnStripped = stripped;
        this.transitionOnBase = base;
    }

    public void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{TRANSITION});
    }

    public int setRadius(LevelAccessor level, BlockPos pos, int radius, @Nullable Direction originDir, int flags) {
        boolean doTransition = false;
        BlockState branch = level.m_8055_(pos);
        if (branch.m_61138_((Property)TRANSITION) && ((Boolean)branch.m_61143_((Property)TRANSITION)).booleanValue()) {
            doTransition = true;
        }
        int rad = super.setRadius(level, pos, radius, originDir, flags);
        if (this.isStrippedBranch()) {
            return rad;
        }
        if (!doTransition && this.transitionOnBase && TreeHelper.isRooty((BlockState)level.m_8055_(pos.m_7495_()))) {
            doTransition = true;
        }
        if (doTransition) {
            level.m_7731_(pos, (BlockState)level.m_8055_(pos).m_61124_((Property)TRANSITION, (Comparable)Boolean.valueOf(true)), flags);
        }
        return rad;
    }

    public void stripBranch(BlockState state, LevelAccessor level, BlockPos pos, int radius) {
        BlockState upState;
        BranchBlock upBranch;
        boolean isTransition = state.m_61138_((Property)TRANSITION) && (Boolean)state.m_61143_((Property)TRANSITION) != false;
        int reducedRadius = this.getFamily().reduceRadiusWhenStripping() && !isTransition ? 1 : 0;
        this.getFamily().getStrippedBranch().ifPresent(strippedBranch -> strippedBranch.setRadius(level, pos, Math.max(1, radius - reducedRadius), null, 3));
        if (this.transitionOnStripped && (upBranch = TreeHelper.getBranch((BlockState)(upState = level.m_8055_(pos.m_7494_())))) != null && !upBranch.isStrippedBranch()) {
            int upRad = upBranch.getRadius(upState);
            int thisRad = TreeHelper.getRadius((BlockGetter)level, (BlockPos)pos);
            BlockState newState = (BlockState)upBranch.getStateForRadius(Math.min(upRad, thisRad)).m_61124_((Property)TRANSITION, (Comparable)Boolean.valueOf(true));
            level.m_7731_(pos.m_7494_(), newState, 3);
        }
    }

    public BlockState getStateForRadius(int radius) {
        return (BlockState)super.getStateForRadius(radius).m_61124_((Property)TRANSITION, (Comparable)Boolean.valueOf(false));
    }
}

