/*
 * Decompiled with CFR 0.152.
 */
package dtteam.dtru.cell;

import com.ferreusveritas.dynamictrees.api.cell.Cell;
import com.ferreusveritas.dynamictrees.api.cell.CellKit;
import com.ferreusveritas.dynamictrees.api.cell.CellNull;
import com.ferreusveritas.dynamictrees.api.cell.CellSolver;
import com.ferreusveritas.dynamictrees.api.registry.Registry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEntry;
import com.ferreusveritas.dynamictrees.cell.AcaciaLeafCell;
import com.ferreusveritas.dynamictrees.cell.CellKits;
import com.ferreusveritas.dynamictrees.cell.LeafClusters;
import com.ferreusveritas.dynamictrees.cell.MatrixCell;
import com.ferreusveritas.dynamictrees.cell.NormalCell;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import dtteam.dtru.DynamicTreesRU;
import dtteam.dtru.cell.BambooLeafCell;
import dtteam.dtru.cell.BambooTopBranchCell;
import dtteam.dtru.cell.DTRULeafClusters;
import dtteam.dtru.cell.PoplarBranchCell;
import dtteam.dtru.cell.PoplarLeafCell;
import dtteam.dtru.cell.PoplarTopBranchCell;
import dtteam.dtru.cell.SparseBranchCell;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;

public class DTRUCellKits {
    public static final CellKit SPARSE = new CellKit(new ResourceLocation("dtru", "sparse")){
        private final Cell sparseBranch = new SparseBranchCell();
        private final Cell sparseLeaves = new NormalCell(1);
        private final CellSolver solver = new CellKits.BasicSolver(new short[]{529});

        public Cell getCellForLeaves(int hydro) {
            return hydro > 0 ? this.sparseLeaves : CellNull.NULL_CELL;
        }

        public Cell getCellForBranch(int radius, int meta) {
            return radius == 1 ? this.sparseBranch : CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTRULeafClusters.SPARSE;
        }

        public CellSolver getCellSolver() {
            return this.solver;
        }

        public int getDefaultHydration() {
            return 1;
        }
    };
    public static final CellKit EUCALYPTUS = new CellKit(new ResourceLocation("dtru", "eucalyptus")){
        private final Cell eucalyptusTopBranch = new BambooTopBranchCell();
        private final Cell eucalyptusBranch = new NormalCell(2);
        private final Cell eucalyptusUpperTrunk = new NormalCell(3);
        private final Cell[] eucalyptusLeaves = new Cell[]{CellNull.NULL_CELL, new BambooLeafCell(1), new BambooLeafCell(2), new BambooLeafCell(3), new BambooLeafCell(4), new BambooLeafCell(5), new BambooLeafCell(6), new BambooLeafCell(7)};
        private final CellSolver solver = new CellKits.BasicSolver(new short[]{1300, 1059, 1041, 786, 529});

        public Cell getCellForLeaves(int hydro) {
            return this.eucalyptusLeaves[hydro];
        }

        public Cell getCellForBranch(int radius, int meta) {
            if (meta == 1) {
                return this.eucalyptusTopBranch;
            }
            if (radius == 1) {
                return this.eucalyptusBranch;
            }
            if (radius <= 3) {
                return this.eucalyptusUpperTrunk;
            }
            return CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTRULeafClusters.BAMBOO;
        }

        public CellSolver getCellSolver() {
            return this.solver;
        }

        public int getDefaultHydration() {
            return 4;
        }
    };
    public static final CellKit POPLAR = new CellKit(new ResourceLocation("dtru", "poplar")){
        private final Cell poplarBranch = new PoplarBranchCell();
        private final Cell poplarTopBranch = new PoplarTopBranchCell();
        private final Cell poplarUpperTrunk = new NormalCell(4);
        private final Cell[] poplarLeaves = new Cell[]{CellNull.NULL_CELL, new PoplarLeafCell(1), new PoplarLeafCell(2), new PoplarLeafCell(3), new PoplarLeafCell(4), new PoplarLeafCell(5), new PoplarLeafCell(6), new PoplarLeafCell(7)};
        private final CellSolver solver = new CellKits.BasicSolver(new short[]{1042, 785, 529});

        public Cell getCellForLeaves(int hydro) {
            return this.poplarLeaves[hydro];
        }

        public Cell getCellForBranch(int radius, int meta) {
            if (meta == 1) {
                return this.poplarTopBranch;
            }
            if (radius == 1) {
                return this.poplarBranch;
            }
            if (radius < 4) {
                return this.poplarUpperTrunk;
            }
            return CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTRULeafClusters.POPLAR;
        }

        public CellSolver getCellSolver() {
            return this.solver;
        }

        public int getDefaultHydration() {
            return 4;
        }
    };
    public static final CellKit BAMBOO = new CellKit(new ResourceLocation("dtru", "bamboo")){
        private final Cell bambooTopBranch = new BambooTopBranchCell();
        private final Cell bambooUpperTrunk = new NormalCell(2);
        private final Cell[] bambooLeaves = new Cell[]{CellNull.NULL_CELL, new BambooLeafCell(1), new BambooLeafCell(2), new BambooLeafCell(3), new BambooLeafCell(4), new BambooLeafCell(5), new BambooLeafCell(6), new BambooLeafCell(7)};
        private final CellSolver solver = new CellKits.BasicSolver(new short[]{1300, 1059, 1041, 786, 529});

        public Cell getCellForLeaves(int hydro) {
            return this.bambooLeaves[hydro];
        }

        public Cell getCellForBranch(int radius, int meta) {
            if (meta == 1) {
                return this.bambooTopBranch;
            }
            if (radius == 2) {
                return this.bambooUpperTrunk;
            }
            return CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTRULeafClusters.BAMBOO;
        }

        public CellSolver getCellSolver() {
            return this.solver;
        }

        public int getDefaultHydration() {
            return 4;
        }
    };
    public static final CellKit DOME = new CellKit(DynamicTreesRU.location("dome")){
        private final Cell acaciaBranch = new Cell(){
            final int[] map = new int[]{0, 3, 5, 5, 5, 5};

            public int getValue() {
                return 5;
            }

            public int getValueFromSide(Direction side) {
                return this.map[side.ordinal()];
            }
        };
        private final Cell[] acaciaLeafCells = new Cell[]{CellNull.NULL_CELL, new AcaciaLeafCell(1), new AcaciaLeafCell(2), new AcaciaLeafCell(3), new AcaciaLeafCell(4), new AcaciaLeafCell(5), new AcaciaLeafCell(6), new AcaciaLeafCell(7)};
        private final CellKits.BasicSolver acaciaSolver = new CellKits.BasicSolver(new short[]{1300, 1059, 1042, 786, 529});

        public Cell getCellForLeaves(int hydro) {
            return this.acaciaLeafCells[hydro];
        }

        public Cell getCellForBranch(int radius, int meta) {
            return radius == 1 ? this.acaciaBranch : CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return LeafClusters.ACACIA;
        }

        public CellSolver getCellSolver() {
            return this.acaciaSolver;
        }

        public int getDefaultHydration() {
            return 4;
        }
    };
    public static final CellKit JOSHUA = new CellKit(DynamicTreesRU.location("joshua")){
        private final Cell branch = new Cell(){

            public int getValue() {
                return 5;
            }

            public int getValueFromSide(Direction side) {
                return side == Direction.UP ? this.getValue() : 0;
            }
        };
        private final Cell[] frondCells = new Cell[]{CellNull.NULL_CELL, new JoshuaFrondCell(1), new JoshuaFrondCell(2), new JoshuaFrondCell(3), new JoshuaFrondCell(4), new JoshuaFrondCell(5), new JoshuaFrondCell(6), new JoshuaFrondCell(7)};
        private final CellKits.BasicSolver joshuaSolver = new CellKits.BasicSolver(new short[]{1300, 1043});

        public Cell getCellForLeaves(int hydro) {
            return this.frondCells[hydro];
        }

        public Cell getCellForBranch(int radius, int meta) {
            return radius == 2 ? this.branch : CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTRULeafClusters.JOSHUA;
        }

        public CellSolver getCellSolver() {
            return this.joshuaSolver;
        }

        public int getDefaultHydration() {
            return 4;
        }

        class JoshuaFrondCell
        extends MatrixCell {
            static final byte[] valMap = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

            public JoshuaFrondCell(int value) {
                super(value, valMap);
            }
        }
    };
    public static final CellKit COBALT = new CellKit(new ResourceLocation("dtru", "cobalt")){
        private final Cell branch = new Cell(){

            public int getValue() {
                return 3;
            }

            public int getValueFromSide(Direction side) {
                return side == Direction.DOWN ? 0 : this.getValue();
            }
        };
        private final Cell[] normalCells = new Cell[]{CellNull.NULL_CELL, new NormalCell(1), new NormalCell(2), new NormalCell(3), new NormalCell(4), new NormalCell(5), new NormalCell(6), new NormalCell(7)};
        private final CellSolver solver = new CellKits.BasicSolver(new short[]{786, 545});

        public Cell getCellForLeaves(int hydro) {
            return this.normalCells[hydro];
        }

        public Cell getCellForBranch(int radius, int meta) {
            return radius == 3 ? this.branch : CellNull.NULL_CELL;
        }

        public SimpleVoxmap getLeafCluster() {
            return DTRULeafClusters.COBALT;
        }

        public CellSolver getCellSolver() {
            return this.solver;
        }

        public int getDefaultHydration() {
            return 2;
        }
    };

    public static void register(Registry<CellKit> registry) {
        registry.registerAll((RegistryEntry[])new CellKit[]{SPARSE, EUCALYPTUS, POPLAR, BAMBOO, DOME, JOSHUA, COBALT});
    }
}

