/*
 * Decompiled with CFR 0.152.
 */
package dtteam.dtru.genfeature;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.systems.nodemapper.FindEndsNode;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.function.CanGrowPredicate;
import com.ferreusveritas.dynamictreesplus.block.mushroom.DynamicCapBlock;
import com.ferreusveritas.dynamictreesplus.tree.HugeMushroomSpecies;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class GlowingPinkBioshroomGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Block> BLOCK = ConfigurationProperty.block((String)"block");
    public static final ConfigurationProperty<Boolean> CUTOUT = ConfigurationProperty.bool((String)"cutout");

    public GlowingPinkBioshroomGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{BLOCK, CAN_GROW_PREDICATE, CUTOUT});
    }

    public boolean shouldApply(Species species, GenFeatureConfiguration configuration) {
        if (configuration.get(BLOCK) == Blocks.f_50016_) {
            return false;
        }
        if (!(species instanceof HugeMushroomSpecies)) {
            return false;
        }
        return super.shouldApply(species, configuration);
    }

    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(BLOCK, (Object)Blocks.f_50016_)).with(CUTOUT, (Object)true)).with(CAN_GROW_PREDICATE, (level, blockPos) -> level.m_213780_().m_188501_() <= 0.05f);
    }

    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        BlockPos.MutableBlockPos testPos = context.pos().m_7494_().m_122032_();
        while (TreeHelper.isBranch((BlockState)context.level().m_8055_((BlockPos)testPos))) {
            testPos.m_122173_(Direction.UP);
        }
        testPos.m_122173_(Direction.DOWN);
        boolean placed = false;
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            if (!this.placeGlowingBlocksInValidPlace(configuration, context.level(), (BlockPos)testPos, dir)) continue;
            placed = true;
        }
        return placed;
    }

    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        FindEndsNode endFinder = new FindEndsNode();
        TreeHelper.startAnalysisFromRoot((LevelAccessor)context.level(), (BlockPos)context.pos(), (MapSignal)new MapSignal(new NodeInspector[]{endFinder}));
        List endPoints = endFinder.getEnds();
        if (endPoints.isEmpty()) {
            return false;
        }
        BlockPos pos = (BlockPos)endPoints.get(0);
        Direction randomDir = Direction.Plane.HORIZONTAL.m_235690_(context.level().m_213780_());
        return context.natural() && ((CanGrowPredicate)configuration.get(CAN_GROW_PREDICATE)).test((Object)context.level(), (Object)context.pos().m_7494_()) && context.fertility() == 0 && this.placeGlowingBlocksInValidPlace(configuration, context.level(), pos, randomDir);
    }

    private boolean placeGlowingBlocksInValidPlace(GenFeatureConfiguration configuration, LevelAccessor level, BlockPos end, Direction dir) {
        Block glowingBlock = (Block)configuration.get(BLOCK);
        BlockPos.MutableBlockPos testPos = end.m_121955_(dir.m_122436_()).m_122032_();
        int layers = 0;
        while (level.m_8055_((BlockPos)testPos).m_60734_() instanceof DynamicCapBlock) {
            BlockState right = level.m_8055_(testPos.m_121955_(dir.m_122427_().m_122436_()));
            BlockState left = level.m_8055_(testPos.m_121955_(dir.m_122428_().m_122436_()));
            if (left.m_60734_() instanceof DynamicCapBlock && right.m_60734_() instanceof DynamicCapBlock) {
                ++layers;
            }
            testPos.m_122173_(Direction.DOWN);
        }
        BlockState edgeState = level.m_8055_((BlockPos)testPos);
        if (edgeState.m_60734_() == glowingBlock) {
            return false;
        }
        if (((Boolean)configuration.get(CUTOUT)).booleanValue()) {
            if (layers >= 2 && edgeState.m_247087_()) {
                level.m_7471_(testPos.m_7494_(), false);
                level.m_7731_(testPos.m_7494_().m_7494_(), glowingBlock.m_49966_(), 3);
            }
        } else if (layers >= 1 && edgeState.m_247087_()) {
            level.m_7731_(testPos.m_7494_(), glowingBlock.m_49966_(), 3);
        }
        return true;
    }
}

