/*
 * Decompiled with CFR 0.152.
 */
package dtteam.dtru.genfeature;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGenerationContext;
import dtteam.dtru.block.TransitionLogBranchBlock;
import dtteam.dtru.tree.TransitionLogFamily;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class StrippedBottomGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Integer> MIN_HEIGHT = ConfigurationProperty.integer((String)"min_height");
    public static final ConfigurationProperty<Integer> MAX_HEIGHT = ConfigurationProperty.integer((String)"max_height");

    public StrippedBottomGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{MIN_HEIGHT, MAX_HEIGHT});
    }

    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(MIN_HEIGHT, (Object)3)).with(MAX_HEIGHT, (Object)5);
    }

    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        BlockPos trunkPos;
        BlockState trunkState;
        int height = context.random().m_216339_(((Integer)configuration.get(MIN_HEIGHT)).intValue(), (Integer)configuration.get(MAX_HEIGHT) + 1);
        LevelAccessor level = context.level();
        for (int i = 1; i < height; ++i) {
            BlockPos trunkPos2 = context.pos().m_6630_(i);
            int rad = TreeHelper.getRadius((BlockGetter)level, (BlockPos)trunkPos2);
            if (rad == 0) continue;
            context.species().getFamily().getStrippedBranch().ifPresent(sb -> sb.setRadius(level, trunkPos2, rad, Direction.UP));
        }
        if (context.species().getFamily() instanceof TransitionLogFamily && (trunkState = level.m_8055_(trunkPos = context.pos().m_6630_(height))).m_61138_((Property)TransitionLogBranchBlock.TRANSITION)) {
            level.m_7731_(trunkPos, (BlockState)trunkState.m_61124_((Property)TransitionLogBranchBlock.TRANSITION, (Comparable)Boolean.valueOf(true)), 2);
        }
        return true;
    }
}

