/*
 * Decompiled with CFR 0.152.
 */
package dtteam.dtru.genfeature;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictreesplus.block.mushroom.DynamicCapCenterBlock;
import com.ferreusveritas.dynamictreesplus.tree.HugeMushroomSpecies;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class TrunkBioshroomGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Block> BLOCK = ConfigurationProperty.block((String)"block");
    public static final ConfigurationProperty<Integer> LOWEST_BLOCK_POS = ConfigurationProperty.integer((String)"lowest_block_pos");

    public TrunkBioshroomGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{BLOCK, LOWEST_BLOCK_POS, PLACE_CHANCE});
    }

    public boolean shouldApply(Species species, GenFeatureConfiguration configuration) {
        if (configuration.get(BLOCK) == Blocks.f_50016_) {
            return false;
        }
        if (!(species instanceof HugeMushroomSpecies)) {
            return false;
        }
        return super.shouldApply(species, configuration);
    }

    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(BLOCK, (Object)Blocks.f_50016_)).with(LOWEST_BLOCK_POS, (Object)3)).with(PLACE_CHANCE, (Object)Float.valueOf(0.05f));
    }

    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        LevelAccessor level = context.level();
        BlockPos.MutableBlockPos testPos = context.pos().m_6630_(((Integer)configuration.get(LOWEST_BLOCK_POS)).intValue()).m_122032_();
        List<BlockPos> validPositions = this.FindValidPositions(level, testPos);
        if (!(context.level().m_8055_((BlockPos)testPos).m_60734_() instanceof DynamicCapCenterBlock)) {
            return false;
        }
        boolean placed = false;
        for (BlockPos pos : validPositions) {
            if (!(level.m_213780_().m_188501_() <= ((Float)configuration.get(PLACE_CHANCE)).floatValue()) || !this.IsFreeAboveAndBelow(level, pos)) continue;
            level.m_7731_(pos, ((Block)configuration.get(BLOCK)).m_49966_(), 2);
            placed = true;
        }
        return placed;
    }

    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        if (context.fertility() == 0) {
            return false;
        }
        LevelAccessor level = context.level();
        BlockPos.MutableBlockPos testPos = context.pos().m_6630_(((Integer)configuration.get(LOWEST_BLOCK_POS)).intValue()).m_122032_();
        List<BlockPos> validPositions = this.FindValidPositions(level, testPos);
        boolean placed = false;
        if (level.m_213780_().m_188501_() <= ((Float)configuration.get(PLACE_CHANCE)).floatValue() && !validPositions.isEmpty()) {
            BlockPos pos = validPositions.get(context.random().m_188503_(validPositions.size()));
            if (this.IsFreeAboveAndBelow(level, pos)) {
                level.m_7731_(pos, ((Block)configuration.get(BLOCK)).m_49966_(), 0);
            }
            placed = true;
        }
        return placed;
    }

    protected List<BlockPos> FindValidPositions(LevelAccessor level, BlockPos.MutableBlockPos testPos) {
        ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
        while (TreeHelper.isBranch((BlockState)level.m_8055_((BlockPos)testPos))) {
            testPos.m_122173_(Direction.UP);
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos side = testPos.m_121955_(dir.m_122436_());
                validPositions.add(side);
            }
        }
        return validPositions;
    }

    private boolean IsFreeAboveAndBelow(LevelAccessor level, BlockPos pos) {
        return level.m_8055_(pos).m_247087_() && level.m_8055_(pos.m_7494_()).m_247087_() && level.m_8055_(pos.m_7495_()).m_247087_();
    }
}

