/*
 * Decompiled with CFR 0.152.
 */
package dtteam.dtru.init;

import com.ferreusveritas.dynamictrees.api.client.ModelHelper;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import dtteam.dtru.block.BambooBranchBlock;
import dtteam.dtru.tree.EucalyptusFamily;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class DTRUClient {
    public static void setup() {
        DTRUClient.registerRenderLayers();
        DTRUClient.registerColorHandlers();
    }

    private static void registerRenderLayers() {
        ForgeRegistries.BLOCKS.getValues().stream().filter(block -> block instanceof BambooBranchBlock).forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110457_()));
    }

    private static void registerColorHandlers() {
        int white = -1;
        int magenta = 0xFF00FF;
        for (EucalyptusFamily family : Family.REGISTRY.getAll().stream().filter(f -> f instanceof EucalyptusFamily).map(f -> (EucalyptusFamily)((Object)f)).collect(Collectors.toSet())) {
            family.getBranch().ifPresent(branchBlock -> ModelHelper.regColorHandler((Block)branchBlock, (state, level, pos, tintIndex) -> pos != null ? family.branchColorMultiplier(state, level, pos) : 0xFF00FF));
            family.getSurfaceRoot().ifPresent(surfaceRoot -> ModelHelper.regColorHandler((Block)surfaceRoot, (state, level, pos, tintIndex) -> pos != null ? family.branchColorMultiplier(state, level, pos) : 0xFF00FF));
        }
    }
}

