/*
 * Decompiled with CFR 0.152.
 */
package dtteam.dtru.init;

import com.ferreusveritas.dynamictrees.api.GatherDataHelper;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.registry.Registry;
import com.ferreusveritas.dynamictrees.api.registry.TypeRegistryEvent;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.block.rooty.SoilProperties;
import com.ferreusveritas.dynamictrees.systems.BranchConnectables;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictreesplus.block.mushroom.CapProperties;
import dtteam.dtru.DynamicTreesRU;
import dtteam.dtru.block.BioshroomCapProperties;
import dtteam.dtru.block.GreenBioshroomCapProperties;
import dtteam.dtru.block.PinkBioshroomCapProperties;
import dtteam.dtru.block.YellowBioshroomCapProperties;
import dtteam.dtru.tree.BioshroomSpecies;
import dtteam.dtru.tree.SmallBioshroomSpecies;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.regions_unexplored.block.RuBlocks;

public class DTRUPlusRegistries {
    public static void gatherData(GatherDataEvent event) {
        GatherDataHelper.gatherAllData((String)"dtru", (GatherDataEvent)event, (Registry[])new Registry[]{SoilProperties.REGISTRY, Family.REGISTRY, Species.REGISTRY, LeavesProperties.REGISTRY, CapProperties.REGISTRY});
    }

    @SubscribeEvent
    public void registerCapPropertiesTypes(TypeRegistryEvent<CapProperties> event) {
        event.registerType(DynamicTreesRU.location("bioshroom_cap"), BioshroomCapProperties.TYPE);
        event.registerType(DynamicTreesRU.location("pink_bioshroom_cap"), PinkBioshroomCapProperties.TYPE);
        event.registerType(DynamicTreesRU.location("yellow_bioshroom_cap"), YellowBioshroomCapProperties.TYPE);
        event.registerType(DynamicTreesRU.location("green_bioshroom_cap"), GreenBioshroomCapProperties.TYPE);
    }

    public static void registerSpeciesTypes(TypeRegistryEvent<Species> event) {
        event.registerType(new ResourceLocation("dtru", "bioshroom"), BioshroomSpecies.TYPE);
        event.registerType(new ResourceLocation("dtru", "small_bioshroom"), SmallBioshroomSpecies.TYPE);
    }

    public static void setup() {
        DTRUPlusRegistries.setupBioshroomConnectable((Block)RuBlocks.BLUE_BIOSHROOM_BLOCK.get());
        DTRUPlusRegistries.setupBioshroomConnectable((Block)RuBlocks.GLOWING_BLUE_BIOSHROOM_BLOCK.get());
        DTRUPlusRegistries.setupBioshroomConnectable((Block)RuBlocks.GLOWING_GREEN_BIOSHROOM_BLOCK.get());
        DTRUPlusRegistries.setupBioshroomConnectable((Block)RuBlocks.GLOWING_PINK_BIOSHROOM_BLOCK.get());
        DTRUPlusRegistries.setupBioshroomConnectable((Block)RuBlocks.GLOWING_YELLOW_BIOSHROOM_BLOCK.get());
        BranchConnectables.makeBlockConnectable((Block)Blocks.f_50701_, (state, level, pos, side) -> {
            if (side.m_122434_() == Direction.Axis.Y) {
                return 0;
            }
            BlockState branchState = level.m_8055_(pos.m_121945_(side.m_122424_()));
            BranchBlock branch = TreeHelper.getBranch((BlockState)branchState);
            return branch != null ? Mth.m_14045_((int)(branch.getRadius(branchState) - 1), (int)1, (int)3) : 1;
        }, (ResourceLocation)new ResourceLocation("dynamictreesplus", "mushroom"));
    }

    private static void setupBioshroomConnectable(Block block) {
        BranchConnectables.makeBlockConnectable((Block)block, (state, level, pos, side) -> {
            if (side.m_122434_() == Direction.Axis.Y) {
                return 0;
            }
            BlockState branchState = level.m_8055_(pos.m_121945_(side.m_122424_()));
            BranchBlock branch = TreeHelper.getBranch((BlockState)branchState);
            return branch != null ? Mth.m_14045_((int)(branch.getRadius(branchState) - 1), (int)1, (int)3) : 1;
        });
    }
}

