/*
 * Decompiled with CFR 0.152.
 */
package dtteam.dtru.init;

import com.ferreusveritas.dynamictrees.api.cell.CellKit;
import com.ferreusveritas.dynamictrees.api.registry.Registry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEntry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEvent;
import com.ferreusveritas.dynamictrees.api.registry.TypeRegistryEvent;
import com.ferreusveritas.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.ferreusveritas.dynamictrees.api.worldgen.FeatureCanceller;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.CommonVoxelShapes;
import com.ferreusveritas.dynamictrees.worldgen.featurecancellation.TreeFeatureCanceller;
import dtteam.dtru.DynamicTreesRU;
import dtteam.dtru.cell.DTRUCellKits;
import dtteam.dtru.genfeature.DTRUGenFeatures;
import dtteam.dtru.growthlogic.DTRUGrowthLogicKits;
import dtteam.dtru.init.DTRUPlusRegistries;
import dtteam.dtru.tree.BambooFamily;
import dtteam.dtru.tree.BrimwoodFamily;
import dtteam.dtru.tree.EucalyptusFamily;
import dtteam.dtru.tree.GenUnderwaterSpecies;
import dtteam.dtru.tree.TransitionLogFamily;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.regions_unexplored.world.features.treedecorators.BlackwoodBioshroom;
import net.regions_unexplored.world.level.feature.configuration.GiantBioshroomConfiguration;
import net.regions_unexplored.world.level.feature.configuration.RuTreeConfiguration;
import net.regions_unexplored.world.level.feature.tree.CobaltShrubFeature;
import net.regions_unexplored.world.level.feature.tree.LargeJoshuaTreeFeature;
import net.regions_unexplored.world.level.feature.tree.MediumJoshuaTreeFeature;
import net.regions_unexplored.world.level.feature.tree.SmallSocotraTreeFeature;
import net.regions_unexplored.world.level.feature.tree.YellowBioshroomShrubFeature;
import net.regions_unexplored.world.level.feature.tree.nether.BrimWillowFeature;
import net.regions_unexplored.world.level.feature.tree.nether.TallBrimWillowFeature;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DTRURegistries {
    public static final VoxelShape MUSHROOM_CAP_CONE_BASE = Shapes.m_83048_((double)0.3125, (double)0.1875, (double)0.3125, (double)0.6875, (double)0.375, (double)0.6875);
    public static final VoxelShape MUSHROOM_CAP_TIP_1 = Shapes.m_83048_((double)0.375, (double)0.375, (double)0.375, (double)0.625, (double)0.5625, (double)0.625);
    public static final VoxelShape MUSHROOM_CAP_SHORT_ROUND = Shapes.m_83048_((double)0.28125, (double)0.1875, (double)0.28125, (double)0.71875, (double)0.5, (double)0.71875);
    public static final VoxelShape SHORT_ROUND_MUSHROOM = Shapes.m_83110_((VoxelShape)CommonVoxelShapes.MUSHROOM_STEM, (VoxelShape)MUSHROOM_CAP_SHORT_ROUND);
    public static final VoxelShape CONE_MUSHROOM = Shapes.m_83110_((VoxelShape)CommonVoxelShapes.MUSHROOM_STEM, (VoxelShape)Shapes.m_83110_((VoxelShape)MUSHROOM_CAP_CONE_BASE, (VoxelShape)MUSHROOM_CAP_TIP_1));
    public static final FeatureCanceller RU_TREE_CANCELLER = new TreeFeatureCanceller(DynamicTreesRU.location("tree"), RuTreeConfiguration.class);
    public static final FeatureCanceller RU_TREE2_CANCELLER = new TreeFeatureCanceller<NoneFeatureConfiguration>(DynamicTreesRU.location("tree_2"), NoneFeatureConfiguration.class){

        public boolean shouldCancel(ConfiguredFeature<?, ?> configuredFeature, BiomePropertySelectors.NormalFeatureCancellation featureCancellations) {
            Feature featureConfig = configuredFeature.f_65377_();
            return featureConfig instanceof LargeJoshuaTreeFeature || featureConfig instanceof MediumJoshuaTreeFeature || featureConfig instanceof SmallSocotraTreeFeature || featureConfig instanceof CobaltShrubFeature || featureConfig instanceof BrimWillowFeature || featureConfig instanceof TallBrimWillowFeature;
        }
    };
    public static final FeatureCanceller RU_MUSHROOM_CANCELLER = new TreeFeatureCanceller(DynamicTreesRU.location("mushroom"), GiantBioshroomConfiguration.class);
    public static final FeatureCanceller RU_MUSHROOM2_CANCELLER = new TreeFeatureCanceller<NoneFeatureConfiguration>(DynamicTreesRU.location("mushroom_2"), NoneFeatureConfiguration.class){

        public boolean shouldCancel(ConfiguredFeature<?, ?> configuredFeature, BiomePropertySelectors.NormalFeatureCancellation featureCancellations) {
            Feature featureConfig = configuredFeature.f_65377_();
            return featureConfig instanceof YellowBioshroomShrubFeature || featureConfig instanceof CobaltShrubFeature || configuredFeature.f_65378_() instanceof HugeMushroomFeatureConfiguration;
        }
    };
    public static final FeatureCanceller TREE_NO_SHROOMS_CANCELLER = new TreeFeatureCanceller<NoneFeatureConfiguration>(DynamicTreesRU.location("tree_no_shrooms"), NoneFeatureConfiguration.class){

        private boolean isConfigClass(FeatureConfiguration config) {
            return config instanceof TreeConfiguration || config instanceof RuTreeConfiguration;
        }

        public boolean shouldCancel(ConfiguredFeature<?, ?> configuredFeature, BiomePropertySelectors.NormalFeatureCancellation featureCancellations) {
            FeatureConfiguration featureConfig = configuredFeature.f_65378_();
            if (this.isConfigClass(featureConfig)) {
                if (featureConfig instanceof TreeConfiguration) {
                    TreeConfiguration treeConfiguration = (TreeConfiguration)featureConfig;
                    if (treeConfiguration.f_68187_.size() > 0 && treeConfiguration.f_68187_.get(0) instanceof BlackwoodBioshroom) {
                        return false;
                    }
                }
                String nameSpace = "";
                ConfiguredFeature nextConfiguredFeature = (ConfiguredFeature)configuredFeature.m_65398_().findFirst().get();
                FeatureConfiguration nextFeatureConfig = nextConfiguredFeature.f_65378_();
                ResourceLocation featureRegistryName = ForgeRegistries.FEATURES.getKey((Object)nextConfiguredFeature.f_65377_());
                if (featureRegistryName != null) {
                    nameSpace = featureRegistryName.m_135827_();
                }
                return this.isConfigClass(nextFeatureConfig) && !nameSpace.equals("") && featureCancellations.shouldCancelNamespace(nameSpace);
            }
            return false;
        }
    };

    public static void setup() {
        CommonVoxelShapes.SHAPES.put(DynamicTreesRU.location("blue_bioshroom").toString(), SHORT_ROUND_MUSHROOM);
        CommonVoxelShapes.SHAPES.put(DynamicTreesRU.location("pink_bioshroom").toString(), CONE_MUSHROOM);
    }

    @SubscribeEvent
    public static void onGenFeatureRegistry(RegistryEvent<GenFeature> event) {
        DTRUGenFeatures.register((Registry<GenFeature>)event.getRegistry());
    }

    @SubscribeEvent
    public static void onGrowthLogicKitRegistry(RegistryEvent<GrowthLogicKit> event) {
        DTRUGrowthLogicKits.register((Registry<GrowthLogicKit>)event.getRegistry());
    }

    @SubscribeEvent
    public static void onCellKitRegistry(RegistryEvent<CellKit> event) {
        DTRUCellKits.register((Registry<CellKit>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerLeavesPropertiesTypes(TypeRegistryEvent<LeavesProperties> event) {
    }

    @SubscribeEvent
    public static void registerSpeciesTypes(TypeRegistryEvent<Species> event) {
        event.registerType(new ResourceLocation("dtru", "cypress"), GenUnderwaterSpecies.TYPE);
        if (DynamicTreesRU.isDynamicTreesPlusLoaded()) {
            DTRUPlusRegistries.registerSpeciesTypes(event);
        }
    }

    @SubscribeEvent
    public static void registerFamilyTypes(TypeRegistryEvent<Family> event) {
        event.registerType(new ResourceLocation("dtru", "bamboo"), BambooFamily.TYPE);
        event.registerType(new ResourceLocation("dtru", "eucalyptus"), EucalyptusFamily.TYPE);
        event.registerType(new ResourceLocation("dtru", "stripped_transition_log"), TransitionLogFamily.TYPE_STRIPPED);
        event.registerType(new ResourceLocation("dtru", "base_transition_log"), TransitionLogFamily.TYPE_BASE);
        event.registerType(new ResourceLocation("dtru", "brimwood"), BrimwoodFamily.TYPE);
    }

    @SubscribeEvent
    public static void onFeatureCancellerRegistry(RegistryEvent<FeatureCanceller> event) {
        event.getRegistry().registerAll((RegistryEntry[])new FeatureCanceller[]{RU_TREE_CANCELLER, RU_TREE2_CANCELLER, RU_MUSHROOM_CANCELLER, RU_MUSHROOM2_CANCELLER, TREE_NO_SHROOMS_CANCELLER});
    }
}

