/*
 * Decompiled with CFR 0.152.
 */
package dtteam.dtru.model;

import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.client.ModelUtils;
import com.ferreusveritas.dynamictrees.models.modeldata.ModelConnections;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.NamedRenderTypeManager;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class EucalyptusBranchBlockBakedModel
implements IDynamicBakedModel {
    protected final BlockModel blockModel;
    protected final ResourceLocation modelLocation;
    protected final TextureAtlasSprite barkTexture;
    protected final TextureAtlasSprite barkOverlayTexture;
    protected final TextureAtlasSprite ringsTexture;
    protected final BakedModel[][] sleeves = new BakedModel[6][7];
    protected final BakedModel[][] cores = new BakedModel[3][8];
    protected final BakedModel[] rings = new BakedModel[8];

    public EucalyptusBranchBlockBakedModel(IGeometryBakingContext customData, ResourceLocation modelLocation, ResourceLocation barkTextureLocation, ResourceLocation ringsTextureLocation, ResourceLocation overlayTextureLocation, Function<Material, TextureAtlasSprite> spriteGetter) {
        this.blockModel = new BlockModel(null, new ArrayList(), new HashMap(), Boolean.valueOf(false), BlockModel.GuiLight.FRONT, ItemTransforms.f_111786_, new ArrayList());
        this.blockModel.customData.setRenderTypeHint(customData.getRenderTypeHint());
        this.modelLocation = modelLocation;
        this.barkTexture = spriteGetter.apply(new Material(InventoryMenu.f_39692_, barkTextureLocation));
        this.barkOverlayTexture = spriteGetter.apply(new Material(InventoryMenu.f_39692_, overlayTextureLocation));
        this.ringsTexture = spriteGetter.apply(new Material(InventoryMenu.f_39692_, ringsTextureLocation));
        this.initModels();
    }

    private void initModels() {
        for (int i = 0; i < 8; ++i) {
            int radius = i + 1;
            if (radius < 8) {
                for (Direction dir : Direction.values()) {
                    this.sleeves[dir.m_122411_()][i] = this.bakeSleeve(radius, dir, this.barkTexture, this.barkOverlayTexture);
                }
            }
            this.cores[0][i] = this.bakeCore(radius, Direction.Axis.Y, this.barkTexture, this.barkOverlayTexture);
            this.cores[1][i] = this.bakeCore(radius, Direction.Axis.Z, this.barkTexture, this.barkOverlayTexture);
            this.cores[2][i] = this.bakeCore(radius, Direction.Axis.X, this.barkTexture, this.barkOverlayTexture);
            this.rings[i] = this.bakeCore(radius, Direction.Axis.Y, this.ringsTexture, this.barkOverlayTexture);
        }
    }

    public BlockElement generateSleevePart(int radius, Direction dir, boolean flipNormals, int tintIndex) {
        boolean negative;
        int dradius = radius * 2;
        int halfSize = (16 - dradius) / 2;
        int halfSizeX = dir.m_122429_() != 0 ? halfSize : dradius;
        int halfSizeY = dir.m_122430_() != 0 ? halfSize : dradius;
        int halfSizeZ = dir.m_122431_() != 0 ? halfSize : dradius;
        int move = 16 - halfSize;
        int centerX = 16 + dir.m_122429_() * move;
        int centerY = 16 + dir.m_122430_() * move;
        int centerZ = 16 + dir.m_122431_() * move;
        Vector3f posFrom = new Vector3f((float)(centerX - halfSizeX) / 2.0f, (float)(centerY - halfSizeY) / 2.0f, (float)(centerZ - halfSizeZ) / 2.0f);
        Vector3f posTo = new Vector3f((float)(centerX + halfSizeX) / 2.0f, (float)(centerY + halfSizeY) / 2.0f, (float)(centerZ + halfSizeZ) / 2.0f);
        if (flipNormals) {
            Vector3f aux = posFrom;
            posFrom = posTo;
            posTo = aux;
            dir = dir.m_122424_();
        }
        boolean bl = negative = dir.m_122421_() == Direction.AxisDirection.NEGATIVE;
        if (dir.m_122434_() == Direction.Axis.Z) {
            negative = !negative;
        }
        EnumMap mapFacesIn = Maps.newEnumMap(Direction.class);
        for (Direction face : Direction.values()) {
            if (dir.m_122424_() == face) continue;
            BlockFaceUV uvface = null;
            if (dir == face) {
                if (radius == 1) {
                    uvface = new BlockFaceUV(new float[]{8 - radius, 8 - radius, 8 + radius, 8 + radius}, 0);
                }
            } else {
                uvface = new BlockFaceUV(new float[]{8 - radius, negative ? (float)(16 - halfSize) : 0.0f, 8 + radius, negative ? 16.0f : (float)halfSize}, this.getFaceAngle(dir.m_122434_(), face));
            }
            if (uvface == null) continue;
            mapFacesIn.put(face, new BlockElementFace(null, tintIndex, null, uvface));
        }
        return new BlockElement(posFrom, posTo, (Map)mapFacesIn, null, true);
    }

    public BakedModel bakeSleeve(int radius, Direction dir, TextureAtlasSprite bark, TextureAtlasSprite overlay) {
        Direction face;
        BlockElement part = this.generateSleevePart(radius, dir, false, -1);
        BlockElement part2 = this.generateSleevePart(radius, dir, false, 0);
        IModelBuilder builder = ModelUtils.getModelBuilder((IGeometryBakingContext)this.blockModel.customData, (TextureAtlasSprite)bark);
        for (Map.Entry e : part.f_111310_.entrySet()) {
            face = (Direction)e.getKey();
            builder.addCulledFace(face, ModelUtils.makeBakedQuad((BlockElement)part, (BlockElementFace)((BlockElementFace)e.getValue()), (TextureAtlasSprite)bark, (Direction)face, (BlockModelRotation)BlockModelRotation.X0_Y0, (ResourceLocation)this.modelLocation));
        }
        for (Map.Entry e : part2.f_111310_.entrySet()) {
            face = (Direction)e.getKey();
            builder.addCulledFace(face, ModelUtils.makeBakedQuad((BlockElement)part2, (BlockElementFace)((BlockElementFace)e.getValue()), (TextureAtlasSprite)overlay, (Direction)face, (BlockModelRotation)BlockModelRotation.X0_Y0, (ResourceLocation)this.modelLocation));
        }
        return builder.build();
    }

    protected BlockElement generateCorePart(int radius, Direction.Axis axis, boolean flipNormals, int tintIndex) {
        Vector3f posFrom = new Vector3f((float)(8 - radius), (float)(8 - radius), (float)(8 - radius));
        Vector3f posTo = new Vector3f((float)(8 + radius), (float)(8 + radius), (float)(8 + radius));
        if (flipNormals) {
            Vector3f aux = posFrom;
            posFrom = posTo;
            posTo = aux;
        }
        EnumMap mapFacesIn = Maps.newEnumMap(Direction.class);
        for (Direction face : Direction.values()) {
            BlockFaceUV uvface = new BlockFaceUV(new float[]{8 - radius, 8 - radius, 8 + radius, 8 + radius}, this.getFaceAngle(axis, face));
            mapFacesIn.put(face, new BlockElementFace(null, tintIndex, null, uvface));
        }
        return new BlockElement(posFrom, posTo, (Map)mapFacesIn, null, true);
    }

    public BakedModel bakeCore(int radius, Direction.Axis axis, TextureAtlasSprite bark, TextureAtlasSprite overlay) {
        Direction face;
        BlockElement part = this.generateCorePart(radius, axis, false, -1);
        BlockElement part2 = this.generateCorePart(radius, axis, false, 0);
        IModelBuilder builder = ModelUtils.getModelBuilder((IGeometryBakingContext)this.blockModel.customData, (TextureAtlasSprite)bark);
        for (Map.Entry e : part.f_111310_.entrySet()) {
            face = (Direction)e.getKey();
            builder.addCulledFace(face, ModelUtils.makeBakedQuad((BlockElement)part, (BlockElementFace)((BlockElementFace)e.getValue()), (TextureAtlasSprite)bark, (Direction)face, (BlockModelRotation)BlockModelRotation.X0_Y0, (ResourceLocation)this.modelLocation));
        }
        for (Map.Entry e : part2.f_111310_.entrySet()) {
            face = (Direction)e.getKey();
            builder.addCulledFace(face, ModelUtils.makeBakedQuad((BlockElement)part2, (BlockElementFace)((BlockElementFace)e.getValue()), (TextureAtlasSprite)overlay, (Direction)face, (BlockModelRotation)BlockModelRotation.X0_Y0, (ResourceLocation)this.modelLocation));
        }
        return builder.build();
    }

    public int getFaceAngle(Direction.Axis axis, Direction face) {
        if (axis == Direction.Axis.Y) {
            return 0;
        }
        if (axis == Direction.Axis.Z) {
            return switch (face) {
                case Direction.UP -> 0;
                case Direction.WEST -> 270;
                case Direction.DOWN -> 180;
                default -> 90;
            };
        }
        return face == Direction.NORTH ? 270 : 90;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, @Nullable RenderType renderType) {
        if (state == null || side != null) {
            return Collections.emptyList();
        }
        ArrayList<BakedQuad> quadsList = new ArrayList<BakedQuad>(24);
        int coreRadius = this.getRadius(state);
        if (coreRadius > 8) {
            return Collections.emptyList();
        }
        int[] connections = new int[]{0, 0, 0, 0, 0, 0};
        Direction forceRingDir = null;
        AtomicInteger twigRadius = new AtomicInteger(1);
        ModelConnections connectionsData = (ModelConnections)extraData.get(ModelConnections.CONNECTIONS_PROPERTY);
        if (connectionsData != null) {
            connections = connectionsData.getAllRadii();
            forceRingDir = connectionsData.getRingOnly();
            connectionsData.getFamily().ifValid(family -> twigRadius.set(family.getPrimaryThickness()));
        }
        int numConnections = 0;
        for (int i : connections) {
            numConnections += i != 0 ? 1 : 0;
        }
        if (numConnections == 0 && forceRingDir != null) {
            quadsList.addAll(this.rings[coreRadius - 1].getQuads(state, forceRingDir, rand, extraData, renderType));
        } else {
            Direction sourceDir = this.getSourceDir(coreRadius, connections);
            int coreDir = this.resolveCoreDir(sourceDir);
            Direction coreRingDir = numConnections == 1 && sourceDir != null ? sourceDir.m_122424_() : null;
            for (Direction face : Direction.values()) {
                if (coreRadius != connections[face.m_122411_()]) {
                    if (coreRingDir == null || coreRingDir != face) {
                        quadsList.addAll(this.cores[coreDir][coreRadius - 1].getQuads(state, face, rand, extraData, renderType));
                    } else {
                        quadsList.addAll(this.rings[coreRadius - 1].getQuads(state, face, rand, extraData, renderType));
                    }
                }
                if (coreRadius == 8) continue;
                for (Direction connDir : Direction.values()) {
                    int idx = connDir.m_122411_();
                    int connRadius = connections[idx];
                    if (connRadius <= 0 || connRadius != twigRadius.get() && face == connDir) continue;
                    quadsList.addAll(this.sleeves[idx][connRadius - 1].getQuads(state, face, rand, extraData, renderType));
                }
            }
        }
        return quadsList;
    }

    @Nonnull
    public ModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull ModelData tileData) {
        ModelConnections modelConnections;
        Block block = state.m_60734_();
        if (block instanceof BranchBlock) {
            BranchBlock branchBlock = (BranchBlock)block;
            modelConnections = new ModelConnections(branchBlock.getConnectionData(world, pos, state)).setFamily(branchBlock.getFamily());
        } else {
            modelConnections = new ModelConnections();
        }
        return modelConnections.toModelData(tileData);
    }

    @Nullable
    protected Direction getSourceDir(int coreRadius, int[] connections) {
        int largestConnection = 0;
        Direction sourceDir = null;
        for (Direction dir : Direction.values()) {
            int connRadius = connections[dir.m_122411_()];
            if (connRadius <= largestConnection) continue;
            largestConnection = connRadius;
            sourceDir = dir;
        }
        if (largestConnection < coreRadius) {
            sourceDir = null;
        }
        return sourceDir;
    }

    protected int resolveCoreDir(@Nullable Direction dir) {
        if (dir == null) {
            return 0;
        }
        return dir.m_122411_() >> 1;
    }

    protected int getRadius(BlockState blockState) {
        return ((BranchBlock)blockState.m_60734_()).getRadius(blockState);
    }

    public boolean m_7541_() {
        return true;
    }

    public TextureAtlasSprite m_6160_() {
        return this.barkTexture;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    public boolean m_7547_() {
        return false;
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{this.getRenderType()});
    }

    public RenderType getRenderType() {
        ResourceLocation renderTypeHint = this.blockModel.customData.getRenderTypeHint();
        if (renderTypeHint == null) {
            return RenderType.m_110457_();
        }
        return NamedRenderTypeManager.get((ResourceLocation)renderTypeHint).block();
    }
}

