/*
 * Decompiled with CFR 0.152.
 */
package dtteam.dtru.model;

import com.ferreusveritas.dynamictrees.block.branch.SurfaceRootBlock;
import com.ferreusveritas.dynamictrees.client.ModelUtils;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.RootConnections;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.NamedRenderTypeManager;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class EucalyptusSurfaceRootBlockBakedModel
implements IDynamicBakedModel {
    private final BlockModel blockModel;
    private final ResourceLocation modelLocation;
    private final TextureAtlasSprite barkTexture;
    private final TextureAtlasSprite overlayTexture;
    private final BakedModel[][] sleeves = new BakedModel[4][7];
    private final BakedModel[][] cores = new BakedModel[2][8];
    private final BakedModel[][] verts = new BakedModel[4][8];

    public EucalyptusSurfaceRootBlockBakedModel(ResourceLocation modelLocation, ResourceLocation barkTextureLocation, ResourceLocation overlayTextureLocation, Function<Material, TextureAtlasSprite> spriteGetter) {
        this.blockModel = new BlockModel(null, new ArrayList(), new HashMap(), Boolean.valueOf(false), BlockModel.GuiLight.FRONT, ItemTransforms.f_111786_, new ArrayList());
        this.modelLocation = modelLocation;
        this.barkTexture = spriteGetter.apply(new Material(InventoryMenu.f_39692_, barkTextureLocation));
        this.overlayTexture = spriteGetter.apply(new Material(InventoryMenu.f_39692_, overlayTextureLocation));
        this.initModels();
    }

    public void initModels() {
        for (int r = 0; r < 8; ++r) {
            int radius = r + 1;
            if (radius < 8) {
                for (Direction dir : CoordUtils.HORIZONTALS) {
                    int horIndex = dir.m_122416_();
                    this.sleeves[horIndex][r] = this.bakeSleeve(radius, dir);
                    this.verts[horIndex][r] = this.bakeVert(radius, dir);
                }
            }
            this.cores[0][r] = this.bakeCore(radius, Direction.Axis.Z, this.barkTexture, this.overlayTexture);
            this.cores[1][r] = this.bakeCore(radius, Direction.Axis.X, this.barkTexture, this.overlayTexture);
        }
    }

    public int getRadialHeight(int radius) {
        return radius * 2;
    }

    public BakedModel bakeSleeve(int radius, Direction dir) {
        boolean sleeveNegative;
        int radialHeight = this.getRadialHeight(radius);
        int dradius = radius * 2;
        int halfSize = (16 - dradius) / 2;
        int halfSizeX = dir.m_122429_() != 0 ? halfSize : dradius;
        int halfSizeZ = dir.m_122431_() != 0 ? halfSize : dradius;
        int move = 16 - halfSize;
        int centerX = 16 + dir.m_122429_() * move;
        int centerZ = 16 + dir.m_122431_() * move;
        Vector3f posFrom = new Vector3f((float)((centerX - halfSizeX) / 2), 0.0f, (float)((centerZ - halfSizeZ) / 2));
        Vector3f posTo = new Vector3f((float)((centerX + halfSizeX) / 2), (float)radialHeight, (float)((centerZ + halfSizeZ) / 2));
        boolean bl = sleeveNegative = dir.m_122421_() == Direction.AxisDirection.NEGATIVE;
        if (dir.m_122434_() == Direction.Axis.Z) {
            sleeveNegative = !sleeveNegative;
        }
        EnumMap mapFacesIn1 = Maps.newEnumMap(Direction.class);
        EnumMap mapFacesIn2 = Maps.newEnumMap(Direction.class);
        for (Direction face : Direction.values()) {
            if (dir.m_122424_() == face) continue;
            BlockFaceUV uvface = null;
            if (face.m_122434_().m_122479_()) {
                boolean facePositive = face.m_122421_() == Direction.AxisDirection.POSITIVE;
                uvface = new BlockFaceUV(new float[]{facePositive ? (float)(16 - radialHeight) : 0.0f, sleeveNegative ? 16 - halfSize : 0, facePositive ? 16.0f : (float)radialHeight, sleeveNegative ? 16 : halfSize}, ModelUtils.getFaceAngle((Direction.Axis)dir.m_122434_(), (Direction)face));
            } else {
                uvface = new BlockFaceUV(new float[]{8 - radius, sleeveNegative ? (float)(16 - halfSize) : 0.0f, 8 + radius, sleeveNegative ? 16.0f : (float)halfSize}, ModelUtils.getFaceAngle((Direction.Axis)dir.m_122434_(), (Direction)face));
            }
            if (uvface == null) continue;
            mapFacesIn1.put(face, new BlockElementFace(null, -1, null, uvface));
            mapFacesIn2.put(face, new BlockElementFace(null, 0, null, uvface));
        }
        BlockElement part1 = new BlockElement(posFrom, posTo, (Map)mapFacesIn1, null, true);
        BlockElement part2 = new BlockElement(posFrom, posTo, (Map)mapFacesIn2, null, true);
        IModelBuilder builder = ModelUtils.getModelBuilder((IGeometryBakingContext)this.blockModel.customData, (TextureAtlasSprite)this.barkTexture);
        for (Map.Entry e : part1.f_111310_.entrySet()) {
            Direction face = (Direction)e.getKey();
            builder.addCulledFace(face, ModelUtils.makeBakedQuad((BlockElement)part1, (BlockElementFace)((BlockElementFace)e.getValue()), (TextureAtlasSprite)this.barkTexture, (Direction)face, (BlockModelRotation)BlockModelRotation.X0_Y0, (ResourceLocation)this.modelLocation));
        }
        for (Map.Entry e : part2.f_111310_.entrySet()) {
            Direction face = (Direction)e.getKey();
            builder.addCulledFace(face, ModelUtils.makeBakedQuad((BlockElement)part2, (BlockElementFace)((BlockElementFace)e.getValue()), (TextureAtlasSprite)this.overlayTexture, (Direction)face, (BlockModelRotation)BlockModelRotation.X0_Y0, (ResourceLocation)this.modelLocation));
        }
        return builder.build();
    }

    private BakedModel bakeVert(int radius, Direction dir) {
        int radialHeight = this.getRadialHeight(radius);
        IModelBuilder builder = ModelUtils.getModelBuilder((IGeometryBakingContext)this.blockModel.customData, (TextureAtlasSprite)this.barkTexture);
        AABB partBoundary = new AABB((double)(8 - radius), (double)radialHeight, (double)(8 - radius), (double)(8 + radius), (double)(16 + radialHeight), (double)(8 + radius)).m_82386_((double)(dir.m_122429_() * 7), 0.0, (double)(dir.m_122431_() * 7));
        for (int i = 0; i < 2; ++i) {
            AABB pieceBoundary = partBoundary.m_82323_(new AABB(0.0, 0.0, 0.0, 16.0, 16.0, 16.0).m_82386_(0.0, (double)(16 * i), 0.0));
            for (Direction face : Direction.values()) {
                EnumMap mapFacesIn1 = Maps.newEnumMap(Direction.class);
                EnumMap mapFacesIn2 = Maps.newEnumMap(Direction.class);
                BlockFaceUV uvface = new BlockFaceUV(ModelUtils.modUV((float[])ModelUtils.getUVs((AABB)pieceBoundary, (Direction)face)), ModelUtils.getFaceAngle((Direction.Axis)Direction.Axis.Y, (Direction)face));
                mapFacesIn1.put(face, new BlockElementFace(null, -1, null, uvface));
                mapFacesIn2.put(face, new BlockElementFace(null, 0, null, uvface));
                Vector3f[] limits = ModelUtils.AABBLimits((AABB)pieceBoundary);
                BlockElement part1 = new BlockElement(limits[0], limits[1], (Map)mapFacesIn1, null, true);
                builder.addCulledFace(face, ModelUtils.makeBakedQuad((BlockElement)part1, (BlockElementFace)((BlockElementFace)part1.f_111310_.get(face)), (TextureAtlasSprite)this.barkTexture, (Direction)face, (BlockModelRotation)BlockModelRotation.X0_Y0, (ResourceLocation)this.modelLocation));
                BlockElement part2 = new BlockElement(limits[0], limits[1], (Map)mapFacesIn2, null, true);
                builder.addCulledFace(face, ModelUtils.makeBakedQuad((BlockElement)part2, (BlockElementFace)((BlockElementFace)part2.f_111310_.get(face)), (TextureAtlasSprite)this.overlayTexture, (Direction)face, (BlockModelRotation)BlockModelRotation.X0_Y0, (ResourceLocation)this.modelLocation));
            }
        }
        return builder.build();
    }

    public BakedModel bakeCore(int radius, Direction.Axis axis, TextureAtlasSprite icon, TextureAtlasSprite overlay) {
        int radialHeight = this.getRadialHeight(radius);
        Vector3f posFrom = new Vector3f((float)(8 - radius), 0.0f, (float)(8 - radius));
        Vector3f posTo = new Vector3f((float)(8 + radius), (float)radialHeight, (float)(8 + radius));
        EnumMap mapFacesIn1 = Maps.newEnumMap(Direction.class);
        EnumMap mapFacesIn2 = Maps.newEnumMap(Direction.class);
        for (Direction face : Direction.values()) {
            BlockFaceUV uvface;
            if (face.m_122434_().m_122479_()) {
                boolean positive = face.m_122421_() == Direction.AxisDirection.POSITIVE;
                uvface = new BlockFaceUV(new float[]{positive ? (float)(16 - radialHeight) : 0.0f, 8 - radius, positive ? 16.0f : (float)radialHeight, 8 + radius}, ModelUtils.getFaceAngle((Direction.Axis)axis, (Direction)face));
            } else {
                uvface = new BlockFaceUV(new float[]{8 - radius, 8 - radius, 8 + radius, 8 + radius}, ModelUtils.getFaceAngle((Direction.Axis)axis, (Direction)face));
            }
            mapFacesIn1.put(face, new BlockElementFace(null, -1, null, uvface));
            mapFacesIn2.put(face, new BlockElementFace(null, 0, null, uvface));
        }
        BlockElement part1 = new BlockElement(posFrom, posTo, (Map)mapFacesIn1, null, true);
        BlockElement part2 = new BlockElement(posFrom, posTo, (Map)mapFacesIn2, null, true);
        IModelBuilder builder = ModelUtils.getModelBuilder((IGeometryBakingContext)this.blockModel.customData, (TextureAtlasSprite)icon);
        for (Map.Entry e : part1.f_111310_.entrySet()) {
            Direction face = (Direction)e.getKey();
            builder.addCulledFace(face, ModelUtils.makeBakedQuad((BlockElement)part1, (BlockElementFace)((BlockElementFace)e.getValue()), (TextureAtlasSprite)icon, (Direction)face, (BlockModelRotation)BlockModelRotation.X0_Y0, (ResourceLocation)this.modelLocation));
        }
        for (Map.Entry e : part2.f_111310_.entrySet()) {
            Direction face = (Direction)e.getKey();
            builder.addCulledFace(face, ModelUtils.makeBakedQuad((BlockElement)part2, (BlockElementFace)((BlockElementFace)e.getValue()), (TextureAtlasSprite)overlay, (Direction)face, (BlockModelRotation)BlockModelRotation.X0_Y0, (ResourceLocation)this.modelLocation));
        }
        return builder.build();
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, @Nullable RenderType renderType) {
        if (side != null || state == null) {
            return Collections.emptyList();
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(24);
        int coreRadius = this.getRadius(state);
        int[] connections = new int[]{0, 0, 0, 0};
        RootConnections.ConnectionLevel[] connectionLevels = (RootConnections.ConnectionLevel[])RootConnections.PLACEHOLDER_CONNECTION_LEVELS.clone();
        RootConnections connectionData = (RootConnections)extraData.get(RootConnections.ROOT_CONNECTIONS_PROPERTY);
        if (connectionData != null) {
            connections = connectionData.getAllRadii();
            connectionLevels = connectionData.getConnectionLevels();
        }
        for (int i = 0; i < connections.length; ++i) {
            connections[i] = Mth.m_14045_((int)connections[i], (int)0, (int)coreRadius);
        }
        Direction sourceDir = this.getSourceDir(coreRadius, connections);
        if (sourceDir == null) {
            sourceDir = Direction.DOWN;
        }
        int coreDir = this.resolveCoreDir(sourceDir);
        boolean isGrounded = state.m_61143_((Property)SurfaceRootBlock.GROUNDED) == Boolean.TRUE;
        for (Direction face : Direction.values()) {
            if (isGrounded) {
                quads.addAll(this.cores[coreDir][coreRadius - 1].getQuads(state, face, rand, extraData, renderType));
            }
            if (coreRadius == 8) continue;
            for (Direction connDir : CoordUtils.HORIZONTALS) {
                int idx = connDir.m_122416_();
                int connRadius = connections[idx];
                if (connRadius <= 0) continue;
                if (isGrounded) {
                    quads.addAll(this.sleeves[idx][connRadius - 1].getQuads(state, face, rand, extraData, renderType));
                }
                if (connectionLevels[idx] != RootConnections.ConnectionLevel.HIGH) continue;
                quads.addAll(this.verts[idx][connRadius - 1].getQuads(state, face, rand, extraData, renderType));
            }
        }
        return quads;
    }

    @Nonnull
    public ModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull ModelData tileData) {
        RootConnections rootConnections;
        Block block = state.m_60734_();
        if (block instanceof SurfaceRootBlock) {
            SurfaceRootBlock surfaceRootBlock = (SurfaceRootBlock)block;
            rootConnections = new RootConnections(surfaceRootBlock.getConnectionData(world, pos));
        } else {
            rootConnections = new RootConnections();
        }
        RootConnections rootConnections2 = rootConnections;
        return ModelData.builder().with(RootConnections.ROOT_CONNECTIONS_PROPERTY, (Object)rootConnections2).build();
    }

    protected Direction getSourceDir(int coreRadius, int[] connections) {
        int largestConnection = 0;
        Direction sourceDir = null;
        for (Direction dir : CoordUtils.HORIZONTALS) {
            int horIndex = dir.m_122416_();
            int connRadius = connections[horIndex];
            if (connRadius <= largestConnection) continue;
            largestConnection = connRadius;
            sourceDir = dir;
        }
        if (largestConnection < coreRadius) {
            sourceDir = null;
        }
        return sourceDir;
    }

    protected int resolveCoreDir(Direction dir) {
        return dir.m_122434_() == Direction.Axis.X ? 1 : 0;
    }

    protected int getRadius(BlockState blockState) {
        return ((SurfaceRootBlock)blockState.m_60734_()).getRadius(blockState);
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.barkTexture;
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    public boolean m_7547_() {
        return false;
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{this.getRenderType()});
    }

    public RenderType getRenderType() {
        ResourceLocation renderTypeHint = this.blockModel.customData.getRenderTypeHint();
        if (renderTypeHint == null) {
            return RenderType.m_110457_();
        }
        return NamedRenderTypeManager.get((ResourceLocation)renderTypeHint).block();
    }
}

