/*
 * Decompiled with CFR 0.152.
 */
package dtteam.dtru.model;

import com.ferreusveritas.dynamictrees.client.ModelUtils;
import com.ferreusveritas.dynamictrees.models.modeldata.ModelConnections;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.google.common.collect.Maps;
import dtteam.dtru.model.EucalyptusBranchBlockBakedModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class ThickEucalyptusBranchBlockBakedModel
extends EucalyptusBranchBlockBakedModel {
    private final BakedModel[] trunksBark = new BakedModel[16];
    private final BakedModel[] trunksTopBark = new BakedModel[16];
    private final BakedModel[] trunksTopRings = new BakedModel[16];
    private final BakedModel[] trunksBotRings = new BakedModel[16];

    public ThickEucalyptusBranchBlockBakedModel(IGeometryBakingContext customData, ResourceLocation modelLocation, ResourceLocation barkTextureLocation, ResourceLocation ringsTextureLocation, ResourceLocation overlayTextureLocation, ResourceLocation thickRingsTextureLocation, Function<Material, TextureAtlasSprite> spriteGetter) {
        super(customData, modelLocation, barkTextureLocation, ringsTextureLocation, overlayTextureLocation, spriteGetter);
        this.initThickModels(spriteGetter.apply(new Material(InventoryMenu.f_39692_, thickRingsTextureLocation)));
    }

    public void initThickModels(TextureAtlasSprite thickRingsTexture) {
        if (this.isTextureNull(thickRingsTexture)) {
            thickRingsTexture = this.ringsTexture;
        }
        for (int i = 0; i < 16; ++i) {
            int radius = i + 8 + 1;
            this.trunksBark[i] = this.bakeTrunkBark(radius, this.barkTexture, this.barkOverlayTexture, true);
            this.trunksTopBark[i] = this.bakeTrunkBark(radius, this.barkTexture, this.barkOverlayTexture, false);
            this.trunksTopRings[i] = this.bakeTrunkRings(radius, thickRingsTexture, Direction.UP);
            this.trunksBotRings[i] = this.bakeTrunkRings(radius, thickRingsTexture, Direction.DOWN);
        }
    }

    private boolean isTextureNull(@Nullable TextureAtlasSprite sprite) {
        return sprite == null || sprite.equals(ModelUtils.getTexture((ResourceLocation)new ResourceLocation("")));
    }

    public BakedModel bakeTrunkBark(int radius, TextureAtlasSprite bark, TextureAtlasSprite overlay, boolean side) {
        Direction[] directionArray;
        IModelBuilder builder = ModelUtils.getModelBuilder((IGeometryBakingContext)this.blockModel.customData, (TextureAtlasSprite)bark);
        AABB wholeVolume = new AABB((double)(8 - radius), 0.0, (double)(8 - radius), (double)(8 + radius), 16.0, (double)(8 + radius));
        if (side) {
            directionArray = CoordUtils.HORIZONTALS;
        } else {
            Direction[] directionArray2 = new Direction[2];
            directionArray2[0] = Direction.UP;
            directionArray = directionArray2;
            directionArray2[1] = Direction.DOWN;
        }
        Direction[] run = directionArray;
        ArrayList<Vec3i> offsets = new ArrayList<Vec3i>();
        for (CoordUtils.Surround surround : CoordUtils.Surround.values()) {
            offsets.add(surround.getOffset());
        }
        offsets.add(new Vec3i(0, 0, 0));
        for (CoordUtils.Surround surround : run) {
            Vec3i dirVector = surround.m_122436_();
            for (Vec3i offset : offsets) {
                if (surround.m_122434_() != Direction.Axis.Y) {
                    Vec3 vec3 = new Vec3((double)dirVector.m_123341_(), (double)dirVector.m_123342_(), (double)dirVector.m_123343_());
                    Vec3 vec32 = new Vec3((double)offset.m_123341_(), (double)offset.m_123342_(), (double)offset.m_123343_());
                    if (!(vec3.m_82549_(vec32).m_82556_() > 2.25)) continue;
                }
                Vec3 scaledOffset = new Vec3((double)(offset.m_123341_() * 16), (double)(offset.m_123342_() * 16), (double)(offset.m_123343_() * 16));
                AABB partBoundary = new AABB(0.0, 0.0, 0.0, 16.0, 16.0, 16.0).m_82383_(scaledOffset).m_82323_(wholeVolume);
                Vector3f[] limits = ModelUtils.AABBLimits((AABB)partBoundary);
                EnumMap mapFacesIn1 = Maps.newEnumMap(Direction.class);
                EnumMap mapFacesIn2 = Maps.newEnumMap(Direction.class);
                BlockFaceUV uvface = new BlockFaceUV(ModelUtils.modUV((float[])ModelUtils.getUVs((AABB)partBoundary, (Direction)surround)), this.getFaceAngle(Direction.Axis.Y, (Direction)surround));
                mapFacesIn1.put(surround, new BlockElementFace(null, -1, null, uvface));
                mapFacesIn2.put(surround, new BlockElementFace(null, 0, null, uvface));
                BlockElement part = new BlockElement(limits[0], limits[1], (Map)mapFacesIn1, null, true);
                builder.addCulledFace((Direction)surround, ModelUtils.makeBakedQuad((BlockElement)part, (BlockElementFace)((BlockElementFace)part.f_111310_.get(surround)), (TextureAtlasSprite)bark, (Direction)surround, (BlockModelRotation)BlockModelRotation.X0_Y0, (ResourceLocation)this.modelLocation));
                BlockElement part2 = new BlockElement(limits[0], limits[1], (Map)mapFacesIn2, null, true);
                builder.addCulledFace((Direction)surround, ModelUtils.makeBakedQuad((BlockElement)part2, (BlockElementFace)((BlockElementFace)part2.f_111310_.get(surround)), (TextureAtlasSprite)overlay, (Direction)surround, (BlockModelRotation)BlockModelRotation.X0_Y0, (ResourceLocation)this.modelLocation));
            }
        }
        return builder.build();
    }

    public BakedModel bakeTrunkRings(int radius, TextureAtlasSprite ring, Direction face) {
        IModelBuilder builder = ModelUtils.getModelBuilder((IGeometryBakingContext)this.blockModel.customData, (TextureAtlasSprite)ring);
        AABB wholeVolume = new AABB((double)(8 - radius), 0.0, (double)(8 - radius), (double)(8 + radius), 16.0, (double)(8 + radius));
        int wholeVolumeWidth = 48;
        ArrayList<Vec3i> offsets = new ArrayList<Vec3i>();
        for (CoordUtils.Surround dir : CoordUtils.Surround.values()) {
            offsets.add(dir.getOffset());
        }
        offsets.add(new Vec3i(0, 0, 0));
        for (Vec3i offset : offsets) {
            Vec3 scaledOffset = new Vec3((double)(offset.m_123341_() * 16), (double)(offset.m_123342_() * 16), (double)(offset.m_123343_() * 16));
            AABB partBoundary = new AABB(0.0, 0.0, 0.0, 16.0, 16.0, 16.0).m_82383_(scaledOffset).m_82323_(wholeVolume);
            Vector3f posFrom = new Vector3f((float)partBoundary.f_82288_, (float)partBoundary.f_82289_, (float)partBoundary.f_82290_);
            Vector3f posTo = new Vector3f((float)partBoundary.f_82291_, (float)partBoundary.f_82292_, (float)partBoundary.f_82293_);
            EnumMap mapFacesIn = Maps.newEnumMap(Direction.class);
            float textureOffsetX = -16.0f;
            float textureOffsetZ = -16.0f;
            float minX = (float)((partBoundary.f_82288_ - (double)textureOffsetX) / (double)wholeVolumeWidth) * 16.0f;
            float maxX = (float)((partBoundary.f_82291_ - (double)textureOffsetX) / (double)wholeVolumeWidth) * 16.0f;
            float minZ = (float)((partBoundary.f_82290_ - (double)textureOffsetZ) / (double)wholeVolumeWidth) * 16.0f;
            float maxZ = (float)((partBoundary.f_82293_ - (double)textureOffsetZ) / (double)wholeVolumeWidth) * 16.0f;
            if (face == Direction.DOWN) {
                minZ = (float)((partBoundary.f_82293_ - (double)textureOffsetZ) / (double)wholeVolumeWidth) * 16.0f;
                maxZ = (float)((partBoundary.f_82290_ - (double)textureOffsetZ) / (double)wholeVolumeWidth) * 16.0f;
            }
            float[] uvs = new float[]{minX, minZ, maxX, maxZ};
            BlockFaceUV uvface = new BlockFaceUV(uvs, this.getFaceAngle(Direction.Axis.Y, face));
            mapFacesIn.put(face, new BlockElementFace(null, -1, null, uvface));
            BlockElement part = new BlockElement(posFrom, posTo, (Map)mapFacesIn, null, true);
            builder.addCulledFace(face, ModelUtils.makeBakedQuad((BlockElement)part, (BlockElementFace)((BlockElementFace)part.f_111310_.get(face)), (TextureAtlasSprite)ring, (Direction)face, (BlockModelRotation)BlockModelRotation.X0_Y0, (ResourceLocation)this.modelLocation));
        }
        return builder.build();
    }

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
        if (state == null || side != null) {
            return Collections.emptyList();
        }
        int coreRadius = this.getRadius(state);
        if (coreRadius <= 8) {
            return super.getQuads(state, null, rand, extraData, renderType);
        }
        coreRadius = Mth.m_14045_((int)coreRadius, (int)9, (int)24);
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(30);
        int[] connections = new int[]{0, 0, 0, 0, 0, 0};
        Direction forceRingDir = null;
        int twigRadius = 1;
        ModelConnections connectionsData = (ModelConnections)extraData.get(ModelConnections.CONNECTIONS_PROPERTY);
        if (connectionsData != null) {
            connections = connectionsData.getAllRadii();
            forceRingDir = connectionsData.getRingOnly();
            Family family = connectionsData.getFamily();
            if (family.isValid()) {
                twigRadius = family.getPrimaryThickness();
            }
        }
        int numConnections = 0;
        for (int i : connections) {
            numConnections += i != 0 ? 1 : 0;
        }
        if (numConnections == 0 && forceRingDir != null) {
            return quads;
        }
        if (forceRingDir != null) {
            connections[forceRingDir.m_122411_()] = 0;
            quads.addAll(this.trunksBotRings[coreRadius - 9].getQuads(state, forceRingDir, rand, extraData, renderType));
        }
        boolean branchesAround = connections[2] + connections[3] + connections[4] + connections[5] != 0;
        for (Direction face : Direction.values()) {
            quads.addAll(this.trunksBark[coreRadius - 9].getQuads(state, face, rand, extraData, renderType));
            if (face != Direction.UP && face != Direction.DOWN) continue;
            if (connections[face.m_122411_()] < twigRadius && !branchesAround) {
                quads.addAll(this.trunksTopRings[coreRadius - 9].getQuads(state, face, rand, extraData, renderType));
                continue;
            }
            if (connections[face.m_122411_()] >= coreRadius) continue;
            quads.addAll(this.trunksTopBark[coreRadius - 9].getQuads(state, face, rand, extraData, renderType));
        }
        return quads;
    }
}

