/*
 * Decompiled with CFR 0.152.
 */
package dtteam.dtru.tree;

import com.ferreusveritas.dynamictrees.api.data.BranchStateGenerator;
import com.ferreusveritas.dynamictrees.api.data.Generator;
import com.ferreusveritas.dynamictrees.api.registry.RegistryHandler;
import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.branch.ThickBranchBlock;
import com.ferreusveritas.dynamictrees.data.provider.DTBlockStateProvider;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.util.MutableLazyValue;
import com.ferreusveritas.dynamictrees.util.Optionals;
import com.ferreusveritas.dynamictrees.util.ResourceLocationUtils;
import dtteam.dtru.tree.TransitionLogFamily;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class BrimwoodFamily
extends TransitionLogFamily {
    public static final TypedRegistry.EntryType<Family> TYPE = TypedRegistry.newType(BrimwoodFamily::new);
    protected Supplier<BranchBlock> magmaBranch;
    protected Block primitiveMagmaLog;
    protected final MutableLazyValue<Generator<DTBlockStateProvider, Family>> magmaBranchStateGenerator = MutableLazyValue.supplied(MagmaBranchStateGenerator::new);

    public BrimwoodFamily(ResourceLocation name) {
        super(name, false, false);
    }

    public void setupBlocks() {
        super.setupBlocks();
        this.magmaBranch = this.setupBranch(this.createMagmaBranch(this.getBranchName("magma_")), true);
    }

    protected BranchBlock createMagmaBranchBlock(ResourceLocation name) {
        ThickBranchBlock branch = new ThickBranchBlock(name, this.getProperties()){

            public Optional<Block> getPrimitiveLog() {
                Family family = this.getFamily();
                if (family instanceof BrimwoodFamily) {
                    BrimwoodFamily magmaLogFamily = (BrimwoodFamily)family;
                    return magmaLogFamily.getPrimitiveMagmaLog();
                }
                return super.getPrimitiveLog();
            }
        };
        if (this.isFireProof()) {
            branch.setFireSpreadSpeed(0).setFlammability(0);
        }
        return branch;
    }

    protected Supplier<BranchBlock> createMagmaBranch(ResourceLocation name) {
        return RegistryHandler.addBlock((ResourceLocation)ResourceLocationUtils.suffix((ResourceLocation)name, (String)this.getBranchNameSuffix()), () -> this.createMagmaBranchBlock(name));
    }

    public Family setPrimitiveMagmaLog(Block primitiveLog) {
        this.primitiveMagmaLog = primitiveLog;
        this.magmaBranch.get().setPrimitiveLogDrops(new ItemStack[]{new ItemStack((ItemLike)primitiveLog)});
        return this;
    }

    public Optional<BranchBlock> getMagmaBranch() {
        return Optionals.ofBlock((Block)this.magmaBranch.get());
    }

    public Optional<Block> getPrimitiveMagmaLog() {
        return Optionals.ofBlock((Block)this.primitiveMagmaLog);
    }

    public void generateStateData(DTBlockStateProvider provider) {
        super.generateStateData(provider);
        ((Generator)this.magmaBranchStateGenerator.get()).generate((DataProvider)provider, (Object)this);
    }

    public static class MagmaBranchStateGenerator
    extends BranchStateGenerator {
        @NotNull
        public Generator.Dependencies gatherDependencies(@NotNull Family input) {
            if (input instanceof BrimwoodFamily) {
                BrimwoodFamily castedInput = (BrimwoodFamily)input;
                return new Generator.Dependencies().append(BRANCH, castedInput.getMagmaBranch()).append(PRIMITIVE_LOG, castedInput.getPrimitiveMagmaLog());
            }
            return super.gatherDependencies(input);
        }
    }
}

